/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.vividsolutions.jump.workbench.model.CategoryEventType;
import com.vividsolutions.jump.workbench.model.HasName;
import com.vividsolutions.jump.workbench.model.HasVisibility;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.LayerableComparator;
import de.riwagis.util.Config;
import java.text.Collator;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.tree.TreePath;
import org.locationtech.jts.util.Assert;

@XStreamAlias(value="cat")
public class Category
implements HasVisibility,
HasName {
    private static final Collator col = Collator.getInstance(Config.LOCALE);
    private final List<Layerable> layerables = new ArrayList<Layerable>();
    private final List<Category> subcategories = new ArrayList<Category>();
    private String name;
    private String description = "";
    private boolean visible = true;
    private transient boolean fireEvents = true;
    private transient Category parentCat = null;
    private transient LayerManager layerManager;
    private transient boolean modified = false;

    public boolean isBuildIn() {
        return this.getLayerManager().isBuildIn(this);
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean _modified) {
        this.modified = _modified;
    }

    private Object readResolve() {
        this.fireEvents = true;
        return this;
    }

    public TreePath getTreePath() {
        Category cat = this;
        ArrayList<Object> lstTreePath = new ArrayList<Object>();
        while (cat.getParentCategory() != null) {
            cat = cat.getParentCategory();
            lstTreePath.add(0, cat);
        }
        lstTreePath.add(this);
        lstTreePath.set(0, this.getLayerManager());
        return new TreePath(lstTreePath.toArray());
    }

    public boolean getFiringEvents() {
        return this.fireEvents;
    }

    public void setFiringEvents(boolean _fireEvents) {
        this.fireEvents = _fireEvents;
    }

    public void setName(String name) {
        this.name = name;
        this.modified = true;
        this.fireCategoryChanged(CategoryEventType.METADATA_CHANGED);
    }

    public void setDescription(String description) {
        this.description = description;
        this.modified = true;
        this.fireCategoryChanged(CategoryEventType.METADATA_CHANGED);
    }

    public final void setLayerManager(LayerManager layerManager) {
        this.layerManager = layerManager;
        for (Category tmpcat : this.getSubcategories()) {
            tmpcat.setLayerManager(layerManager);
        }
        for (Layerable tmplyr : this.getLayerables()) {
            tmplyr.setLayerManager(layerManager);
        }
    }

    public void fireCategoryChanged(CategoryEventType type) {
        if (!this.fireEvents) {
            return;
        }
        if (this.getLayerManager() == null) {
            return;
        }
        this.getLayerManager().fireCategoryChanged(this, type);
    }

    public LayerManager getLayerManager() {
        return this.layerManager;
    }

    public boolean isVisibleOnScreen() {
        if (this.getParentCategory() == null) {
            return true;
        }
        if (!this.visible) {
            return false;
        }
        return this.getParentCategory().isVisibleOnScreen();
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.visible == visible) {
            return;
        }
        this.visible = visible;
        this.modified = true;
        this.fireCategoryChanged(CategoryEventType.VISIBILITY_CHANGED);
        if (!visible) {
            for (Layerable objLy : this.getAllLayerables()) {
                if (!(objLy instanceof Layer)) continue;
                ((Layer)objLy).clearFeatureCache();
            }
        }
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    private List<Layerable> getSortedLayerables() {
        Layerable[] arrLay = this.layerables.toArray(new Layerable[0]);
        Arrays.sort(arrLay, new LayerableComparator());
        return new ArrayList<Layerable>(Arrays.asList(arrLay));
    }

    public List<Layerable> getLayerables() {
        return Collections.unmodifiableList(this.layerables);
    }

    public List<Layerable> getAllLayerables() {
        ArrayDeque<Category> stack = new ArrayDeque<Category>();
        ArrayList<Layerable> allLayerables = new ArrayList<Layerable>();
        stack.push(this);
        while (!stack.isEmpty()) {
            Category cat = (Category)stack.pop();
            allLayerables.addAll(cat.getLayerables());
            stack.addAll(cat.getSubcategoriesUnordered());
        }
        return allLayerables;
    }

    public List<Category> getSubcategories() {
        Category[] arrCat = this.subcategories.toArray(new Category[0]);
        Arrays.sort(arrCat, new CategoryComparator());
        return new ArrayList<Category>(Arrays.asList(arrCat));
    }

    public Collection<Category> getSubcategoriesUnordered() {
        return Collections.unmodifiableList(this.subcategories);
    }

    public Category getSubcategory(String strName) {
        for (Category cat : this.subcategories) {
            if (!cat.getName().equals(strName)) continue;
            return cat;
        }
        return null;
    }

    public Set<Category> getAllSubcategories() {
        ArrayDeque<Category> stack = new ArrayDeque<Category>();
        HashSet<Category> allCategories = new HashSet<Category>();
        stack.addAll(this.getSubcategoriesUnordered());
        while (!stack.isEmpty()) {
            Category cat = (Category)stack.pop();
            allCategories.add(cat);
            stack.addAll(cat.getSubcategoriesUnordered());
        }
        return allCategories;
    }

    public List<Object> getChildren() {
        ArrayList<Object> lstTemp = new ArrayList<Object>();
        lstTemp.addAll(this.getSubcategories());
        lstTemp.addAll(this.getSortedLayerables());
        return lstTemp;
    }

    public int getNumLayerables() {
        return this.layerables.size();
    }

    public int getNumSubcategories() {
        return this.subcategories.size();
    }

    public void remove(Layerable layerable) {
        this.modified = true;
        Assert.isTrue((boolean)this.contains(layerable));
        layerable.setCategory(null);
    }

    public void remove(Category subcat) {
        this.modified = true;
        Assert.isTrue((boolean)this.contains(subcat));
        subcat.setParentCategory(null);
    }

    public int indexOf(Layerable layerable) {
        return this.layerables.indexOf(layerable);
    }

    public int treeIndexOf(Layerable layerable) {
        if (!this.layerables.contains(layerable)) {
            return -1;
        }
        return this.layerables.indexOf(layerable) + this.subcategories.size();
    }

    public int indexOf(Category subcat) {
        return this.getSubcategories().indexOf(subcat);
    }

    public boolean contains(Layerable layerable) {
        return this.layerables.contains(layerable);
    }

    public boolean contains(Category subcat) {
        return this.subcategories.contains(subcat);
    }

    public void removeLayerableInternal(Layerable layerable) {
        this.modified = true;
        this.layerables.remove(layerable);
    }

    public void addLayerableInternal(int index, Layerable layerable) {
        this.modified = true;
        if (!this.layerables.contains(layerable)) {
            this.layerables.add(index, layerable);
        }
    }

    public void removeSubcategoryInternal(Category subcat) {
        this.modified = true;
        this.subcategories.remove(subcat);
    }

    public void addSubcategoryInternal(int index, Category subcat) {
        this.modified = true;
        if (!this.subcategories.contains(subcat)) {
            this.subcategories.add(index, subcat);
        }
    }

    public void add(int index, Layerable layerable) {
        this.modified = true;
        layerable.setCategory(index, this);
    }

    public void add(int index, Category subcat) {
        this.modified = true;
        subcat.setParentCategory(index, this);
    }

    public int getTreeModelIndex() {
        if (this.parentCat == null) {
            return 0;
        }
        return this.parentCat.indexOf(this);
    }

    public void setParentCategory(Category cat) {
        this.modified = true;
        if (cat == null) {
            this.setParentCategory(0, cat);
            return;
        }
        this.setParentCategory(cat.getNumSubcategories(), cat);
    }

    public void setParentCategory(int index, Category cat) {
        this.modified = true;
        if (this.parentCat != null) {
            this.fireCategoryChanged(CategoryEventType.REMOVED);
            this.parentCat.removeSubcategoryInternal(this);
            this.parentCat.fireCategoryChanged(CategoryEventType.METADATA_CHANGED);
        }
        this.parentCat = cat;
        if (cat == null) {
            return;
        }
        int newIndex = Math.min(index, this.parentCat.getNumSubcategories());
        this.parentCat.addSubcategoryInternal(newIndex, this);
        if (this.parentCat.getLayerManager() != this.layerManager) {
            this.setLayerManager(this.parentCat.getLayerManager());
        }
        this.fireCategoryChanged(CategoryEventType.ADDED);
    }

    public Category getParentCategory() {
        return this.parentCat;
    }

    public void addPersistentLayerable(Layerable layerable) {
        this.modified = true;
        layerable.setCategory(this);
    }

    public void addSubcategory(Category subcat) {
        this.modified = true;
        subcat.setParentCategory(this);
    }

    public boolean isEmpty() {
        return this.layerables.isEmpty() && this.subcategories.isEmpty();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.getName();
    }

    public String getRenderError() {
        StringBuilder sbError = new StringBuilder();
        for (Layerable layerable : this.layerables) {
            String renderError = layerable.getRenderError();
            if (renderError == null) continue;
            sbError.append(layerable.getName()).append(": ").append(renderError).append("<br/>");
        }
        for (Category category : this.subcategories) {
            String strRenderError = category.getRenderError();
            if (strRenderError == null) continue;
            sbError.append(strRenderError);
        }
        if (sbError.length() == 0) {
            return null;
        }
        return sbError.toString();
    }

    private static class CategoryComparator
    implements Comparator<Category> {
        private CategoryComparator() {
        }

        @Override
        public final int compare(Category _a, Category _b) {
            if (_a == null || _b == null) {
                return 0;
            }
            return col.compare(_a.getName().toLowerCase(Config.LOCALE), _b.getName().toLowerCase(Config.LOCALE));
        }
    }
}

