/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.AbstractCadLayer;
import com.vividsolutions.jump.workbench.model.CadLayerSymbolDefinition;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.LayerStyleCollection;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.ui.plugin.layer.cad.CadFeatureAtts;
import de.riwagis.geotools.feature.AreaLinePointFeatureIterator;
import de.riwagis.geotools.feature.OrderByFeatureIterator;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.geotools.feature.util.FilterUtil;
import de.riwagis.riwajump.data.model.FeaturestoreMetadata;
import de.riwagis.riwajump.model.style.CadStyleModel;
import de.riwagis.riwajump.model.style.StyleModel;
import de.riwagis.util.lang.StringComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import lombok.Generated;
import org.geotools.data.FeatureReader;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.util.Assert;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XStreamAlias(value="CadLayer")
public class CadLayer
extends AbstractCadLayer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CadLayer.class);
    private transient SimpleFeatureType cadLayerFeatureType = null;
    private transient InternalLayer internalLyDef = null;
    private transient StyleCollection oldSCol = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CadLayer(String name, FeaturestoreMetadata _fmd, LayerManager layerManager) {
        super(name, _fmd, layerManager);
        boolean firingEvents = layerManager.isFiringEvents();
        layerManager.setFiringEvents(false);
        try {
            LayerStyleCollection styleCollection = new LayerStyleCollection(this, true);
            styleCollection.addStyle((StyleModel)new CadStyleModel());
            styleCollection.setDefault(true);
            this.addStyleCollection(styleCollection);
        }
        finally {
            layerManager.setFiringEvents(firingEvents);
        }
    }

    @Override
    public void fireAppearanceChanged() {
        this.internalLyDef = null;
        super.fireAppearanceChanged();
    }

    @Override
    protected SimpleFeature initDefaultFeature() {
        SimpleFeature feature = super.initDefaultFeature();
        try {
            List<CadLayerSymbolDefinition> lstSymDef = this.getSymbolDefs();
            if (!lstSymDef.isEmpty()) {
                FeatureUtil.setAttribute((SimpleFeature)feature, (String)CadFeatureAtts.SYMBOL.getName(), (Object)lstSymDef.get(0).getSymbolName());
            }
        }
        catch (Exception ex) {
            log.error("Error creating defaultFeature in CadLayer: " + this.toString(), (Throwable)ex);
            Assert.shouldNeverReachHere((String)ex.getMessage());
        }
        return feature;
    }

    public InternalLayer getInternalLayer4NewFeatures() {
        return this.internalLyDef;
    }

    public void setInternalLayer4NewFeatures(InternalLayer internalLayer) {
        this.internalLyDef = internalLayer;
    }

    @Override
    protected void editFeature(SimpleFeature feat, int action, Collection<SimpleFeature> oldFeatures) throws Exception {
        if (action == 1) {
            boolean featureHasLayerSet;
            boolean bl = featureHasLayerSet = FeatureUtil.getAttribute((SimpleFeature)feat, (String)CadFeatureAtts.LAYERNAME.getName()) != null;
            if (this.internalLyDef == null && !featureHasLayerSet) {
                throw new Exception(I18N.getMessage("model.CadLayer.no-theme-defined", this.toString()));
            }
            if (!featureHasLayerSet) {
                CadLayer.setInternalLayer2Feature(feat, this.internalLyDef);
            }
        }
        super.editFeature(feat, action, oldFeatures);
    }

    @Override
    public Filter getEnvelopeFilter(Envelope env, boolean transformToFMD) throws Exception {
        CadStyleModel cadStyle;
        Filter envFilt = super.getEnvelopeFilter(env, transformToFMD);
        LayerStyleCollection sCol = this.getValidLayerStyleCollection();
        if (sCol != null && (cadStyle = sCol.getStyle(CadStyleModel.class)) != null && !cadStyle.isLoadAllLayers() && cadStyle.isUseFiltering() && !cadStyle.getMapLayerID().isEmpty()) {
            StringBuilder sbCQL = new StringBuilder();
            for (String strLayername : cadStyle.getMapLayerID().keySet()) {
                if (sbCQL.length() > 0) {
                    sbCQL.append(" OR ");
                }
                sbCQL.append(FeatureUtil.getAttributeDescriptor((SimpleFeatureType)this.getFeatureType(), (String)CadFeatureAtts.LAYERNAME.getName()).getLocalName()).append("='").append(strLayername).append("'");
            }
            Filter idFilt = FilterUtil.getCQLFilter((String)sbCQL.toString());
            envFilt = FilterUtil.getAndFilter((Filter)envFilt, (Filter)idFilt);
        }
        return envFilt;
    }

    private void clearFeatureCacheIfInvalid(StyleCollection sCol) {
        if (this.oldSCol != null && this.oldSCol != sCol) {
            for (StyleCollection sColTmp : this.getStyleCollections()) {
                CadStyleModel cadStyle = sColTmp.getStyle(CadStyleModel.class);
                if (cadStyle == null || cadStyle.isLoadAllLayers() || !cadStyle.isUseFiltering()) continue;
                this.clearFeatureCache();
                break;
            }
        }
        this.oldSCol = sCol;
    }

    @Override
    public FeatureIterator<SimpleFeature> getRenderIterator(Envelope env) throws Exception {
        CadStyleModel cadStyle;
        LayerStyleCollection sCol = this.getValidLayerStyleCollection();
        this.clearFeatureCacheIfInvalid(sCol);
        FeatureIterator<SimpleFeature> i = super.getRenderIterator(env);
        if (sCol != null && (cadStyle = sCol.getStyle(CadStyleModel.class)) != null) {
            if (cadStyle.isUseOrderBy()) {
                return new OrderByFeatureIterator(i, CadFeatureAtts.ORDER_BY.getName(), false);
            }
            return new AreaLinePointFeatureIterator(i);
        }
        return i;
    }

    public List<InternalLayer> getInternalLayers() {
        ArrayList<InternalLayer> lstIntLayers = new ArrayList<InternalLayer>();
        Collection<StyleCollection> lstSCol = this.getStyleCollections();
        for (StyleCollection sCol : lstSCol) {
            CadStyleModel cadStyle;
            if (sCol.getDefault() && this.isScaleDependentRenderingEnabled() || (cadStyle = sCol.getStyle(CadStyleModel.class)) == null) continue;
            if (cadStyle.isLoadAllLayers()) {
                InternalLayer intLayer = new InternalLayer("default");
                lstIntLayers.clear();
                lstIntLayers.add(intLayer);
                return lstIntLayers;
            }
            for (String strIntLyName : cadStyle.getMapLayerID().keySet()) {
                InternalLayer intLayer = new InternalLayer(strIntLyName);
                if (lstIntLayers.contains(intLayer)) continue;
                lstIntLayers.add(intLayer);
            }
        }
        Collections.sort(lstIntLayers);
        return lstIntLayers;
    }

    @Override
    public int getLayerType() {
        return 3;
    }

    public static InternalLayer internalLayer4Feature(SimpleFeature f) {
        return new InternalLayer((String)FeatureUtil.getAttribute((SimpleFeature)f, (String)CadFeatureAtts.LAYERNAME.getName()));
    }

    public static void setInternalLayer2Feature(SimpleFeature f, InternalLayer intLay) {
        if (FeatureUtil.hasAttribute((SimpleFeature)f, (String)CadFeatureAtts.LAYERNAME.getName())) {
            FeatureUtil.setAttribute((SimpleFeature)f, (String)CadFeatureAtts.LAYERNAME.getName(), (Object)intLay.getLayerName());
        }
    }

    @Override
    public SimpleFeatureType getDefaultFeatureType() {
        if (this.cadLayerFeatureType == null) {
            SimpleFeatureTypeBuilder ftFac = new SimpleFeatureTypeBuilder();
            for (CadFeatureAtts att : CadFeatureAtts.values()) {
                ftFac.add(att.getName(), att.getType());
            }
            ftFac.setName("cadlayer");
            try {
                this.cadLayerFeatureType = ftFac.buildFeatureType();
            }
            catch (Throwable t) {
                log.error("Fatal error initializing CadLayerFeatureType.", t);
            }
        }
        return this.cadLayerFeatureType;
    }

    public Set<String> autoDetectLayers() throws Exception {
        try {
            SimpleFeatureType fType = this.getFMD().getQuerySchema(this.getDMDCol());
            if (fType == null) {
                return Collections.emptySet();
            }
            if (!FeatureUtil.hasAttributeDescriptor((SimpleFeatureType)fType, (String)CadFeatureAtts.LAYERNAME.getName())) {
                return Collections.emptySet();
            }
        }
        catch (Throwable t) {
            return Collections.emptySet();
        }
        HashSet<String> layers = new HashSet<String>();
        try (FeatureReader<SimpleFeatureType, SimpleFeature> reader = this.getFMD().getFeatureReader(this.getDMDCol(), (Filter)Filter.INCLUDE);){
            while (reader.hasNext()) {
                SimpleFeature feat = (SimpleFeature)reader.next();
                Object objLyName = FeatureUtil.getAttribute((SimpleFeature)feat, (String)CadFeatureAtts.LAYERNAME.getName());
                String strLyName = Objects.toString(objLyName, "");
                layers.add(strLyName);
            }
        }
        return layers;
    }

    @Override
    public boolean displayedTreeNodeContains(String searchValue) {
        if (super.displayedTreeNodeContains(searchValue)) {
            return true;
        }
        Stream cadStyleMapeLayerEntrySets = this.getStyleCollections().stream().filter(styleCollection -> !styleCollection.getLayerable().isScaleDependentRenderingEnabled() || styleCollection.getLayerable().isScaleDependentRenderingEnabled() && !styleCollection.getDefault()).flatMap(sCol -> sCol.getStyles().stream()).filter(styleModel -> styleModel instanceof CadStyleModel).map(styleModel -> (CadStyleModel)styleModel).filter(styleModel -> !styleModel.isLoadAllLayers()).flatMap(cadStyle -> cadStyle.getMapLayerID().entrySet().stream());
        return cadStyleMapeLayerEntrySets.anyMatch(entrySet -> entrySet.getKey() != null && !((String)entrySet.getKey()).isBlank() && ((String)entrySet.getKey()).toLowerCase().contains(searchValue.toLowerCase()));
    }

    public static class InternalLayer
    implements Comparable<InternalLayer> {
        private static final StringComparator COMP = new StringComparator();
        private String layerName = null;

        public InternalLayer(String layerName) {
            this.layerName = layerName;
        }

        public boolean equals(Object candidate) {
            if (!(candidate instanceof InternalLayer)) {
                return false;
            }
            boolean layerNameOK = false;
            InternalLayer other = (InternalLayer)candidate;
            if (other.layerName == null || this.layerName == null) {
                if (other.layerName == null && this.layerName == null) {
                    layerNameOK = true;
                }
            } else {
                layerNameOK = other.layerName.equals(this.layerName);
            }
            return layerNameOK;
        }

        public String getLayerName() {
            return this.layerName;
        }

        public String toString() {
            return this.layerName;
        }

        @Override
        public int compareTo(InternalLayer o) {
            return COMP.compare((Object)this.layerName, (Object)o.layerName);
        }
    }
}

