/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model;

import com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import de.riwagis.riwajump.model.style.StyleModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.util.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLayerable
implements Layerable,
Serializable,
Cloneable {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractLayerable.class);
    private String name;
    private String key = I18N.get("model.AbstractLayerable.key-init");
    private boolean visible = true;
    private boolean visibleInViewerTree = true;
    private boolean scaleDependentRenderingEnabled = false;
    private int intRenderPrio = 0;
    private String description = "";
    private boolean exportable = true;
    @XStreamOmitField
    private boolean layerInitialized = false;
    private List<StyleCollection> lstStyleCollections = new ArrayList<StyleCollection>();
    private transient String strRenderError = null;
    private transient LayerManager layerManager;
    private transient Category category = null;
    private transient boolean modified = true;
    private transient boolean disposed = false;

    public AbstractLayerable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractLayerable(String name, LayerManager layerManager) {
        Assert.isTrue((name != null ? 1 : 0) != 0);
        Assert.isTrue((layerManager != null ? 1 : 0) != 0);
        this.setKey(layerManager.uniqueLayerKey(name));
        this.setLayerManager(layerManager);
        boolean firingEvents = layerManager.isFiringEvents();
        layerManager.setFiringEvents(false);
        try {
            this.setName(layerManager.uniqueLayerName(name));
        }
        finally {
            layerManager.setFiringEvents(firingEvents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractLayerable clone() throws CloneNotSupportedException {
        boolean isFiringEvents = this.getLayerManager().isFiringEvents();
        this.getLayerManager().setFiringEvents(false);
        try {
            AbstractLayerable clone = (AbstractLayerable)super.clone();
            clone.lstStyleCollections = new ArrayList<StyleCollection>();
            for (StyleCollection sCol : this.getStyleCollections()) {
                clone.addStyleCollection(sCol.clone());
            }
            clone.setLayerManager(LayerManager.dummyLayerManager);
            clone.setCategory(null);
            AbstractLayerable abstractLayerable = clone;
            return abstractLayerable;
        }
        finally {
            this.getLayerManager().setFiringEvents(isFiringEvents);
        }
    }

    @Override
    public Collection<Layerable> reload() {
        this.fireLayerChanged(LayerEventType.VISIBILITY_CHANGED);
        ArrayList<Layerable> retList = new ArrayList<Layerable>();
        retList.add(this);
        return retList;
    }

    @Override
    public int getRenderPrio() {
        return this.intRenderPrio;
    }

    @Override
    public void setRenderPrio(int renderPrio) {
        this.intRenderPrio = renderPrio;
    }

    @Override
    public String getRenderError() {
        return this.strRenderError;
    }

    @Override
    public void setRenderError(String strError) {
        if (strError == null) {
            if (this.strRenderError != null) {
                this.strRenderError = null;
                this.fireLayerChanged(LayerEventType.METADATA_CHANGED);
            }
            return;
        }
        if (this.strRenderError == null) {
            this.strRenderError = strError;
            this.fireLayerChanged(LayerEventType.METADATA_CHANGED);
            return;
        }
        if (WorkbenchContext.getFrame() != null) {
            WorkbenchContext.getFrame().log(String.format("%s %s: %s", I18N.get("common.layer"), this.getName(), strError));
        }
        LOG.error("{} {}: {}", new Object[]{I18N.get("common.layer"), this.getName(), strError});
    }

    @Override
    public void cleanUp() {
        for (StyleCollection sCol : this.getStyleCollections()) {
            sCol.cleanUp();
        }
        if (!this.isScaleDependentRenderingEnabled()) {
            ArrayList<StyleCollection> lst2Remove = new ArrayList<StyleCollection>();
            for (StyleCollection scol : this.lstStyleCollections) {
                if (scol.getDefault()) continue;
                lst2Remove.add(scol);
            }
            for (StyleCollection scol : lst2Remove) {
                this.lstStyleCollections.remove(scol);
            }
        }
    }

    @Override
    public void dispose() {
        this.disposed = true;
        this.layerManager = LayerManager.dummyLayerManager;
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public int compareTo(Layerable layerobj) {
        if (layerobj instanceof Layerable) {
            long diff = (long)this.intRenderPrio - (long)layerobj.getRenderPrio();
            if (diff > Integer.MAX_VALUE) {
                diff = Integer.MAX_VALUE;
            }
            if (diff < Integer.MIN_VALUE) {
                diff = Integer.MIN_VALUE;
            }
            return (int)diff;
        }
        return 0;
    }

    @Override
    public boolean isBuildIn() {
        return this.getLayerManager().isBuildIn(this);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        Assert.isTrue((description != null ? 1 : 0) != 0, (String)"Java2XML requires that the description be non-null. Use an empty string if necessary.");
        this.description = description;
    }

    @Override
    public boolean isVisibleInViewerTree() {
        return this.visibleInViewerTree;
    }

    @Override
    public void setVisibleInViewerTree(boolean visibleInViewerTree) {
        this.visibleInViewerTree = visibleInViewerTree;
    }

    public double getScreenScale() {
        return this.layerManager.getScreenScale();
    }

    @Override
    public void setLayerManager(LayerManager layerManager) {
        this.layerManager = layerManager;
    }

    @Override
    public LayerManager getLayerManager() {
        return this.layerManager;
    }

    @Override
    public void setCategory(Category cat) {
        this.modified = true;
        if (cat == null) {
            this.setCategory(0, cat);
            return;
        }
        this.setCategory(cat.getNumLayerables(), cat);
    }

    @Override
    public void setCategory(int index, Category cat) {
        this.modified = true;
        if (this.category != null) {
            this.category.removeLayerableInternal(this);
            this.fireLayerChanged(LayerEventType.REMOVED);
        }
        this.category = cat;
        if (cat == null) {
            return;
        }
        this.category.addLayerableInternal(Math.min(index, this.category.getNumLayerables()), this);
        if (this.category.getLayerManager() != this.layerManager) {
            this.layerManager = this.category.getLayerManager();
        }
        this.fireLayerChanged(LayerEventType.ADDED);
    }

    @Override
    public Category getCategory() {
        return this.category;
    }

    public void fireLayerChanged(LayerEventType type) {
        if (this.getLayerManager() != null) {
            this.getLayerManager().fireLayerChanged(this, type);
        }
    }

    public void fireAppearanceChanged() {
        this.fireLayerChanged(LayerEventType.APPEARANCE_CHANGED);
    }

    @Override
    public void setKey(String _key) {
        if (_key == null || _key.length() == 0) {
            Assert.shouldNeverReachHere((String)"A layer can not have an empty key.");
        }
        String uniqueKey = _key;
        if (this.getLayerManager() != null && this.getLayerManager().hasLayerable(_key) && !this.getKey().equals(_key)) {
            uniqueKey = this.getLayerManager().uniqueLayerKey(_key);
        }
        this.modified = true;
        this.key = uniqueKey;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (!StringUtils.equals((CharSequence)this.name, (CharSequence)name)) {
            this.name = name;
            this.modified = true;
            this.fireLayerChanged(LayerEventType.METADATA_CHANGED);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        this.modified = true;
        if (this.visible == visible) {
            return;
        }
        this.visible = visible;
        this.fireLayerChanged(LayerEventType.VISIBILITY_CHANGED);
    }

    @Override
    public boolean isVisibleOnScreen() {
        return this.isVisibleOnScreen(false);
    }

    @Override
    public boolean isVisibleOnScreen(boolean ignoreScaleRange) {
        if (this.getCategory() == null) {
            return false;
        }
        if (!this.visible) {
            return false;
        }
        if (!ignoreScaleRange && !this.withinVisibleScaleRange()) {
            return false;
        }
        return this.getCategory().isVisibleOnScreen();
    }

    @Override
    public void setVisibleOnScreen() {
        if (!this.isVisible()) {
            this.setVisible(true);
        }
        if (this.getCategory() == null) {
            return;
        }
        for (Category cat = this.getCategory(); cat != null; cat = cat.getParentCategory()) {
            if (cat.isVisible()) continue;
            cat.setVisible(true);
        }
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public String toString() {
        Category cat = this.getCategory();
        if (cat != null) {
            return String.format("%s (%s)", this.getName(), cat.getName());
        }
        return this.getName();
    }

    @Override
    public boolean isScaleDependentRenderingEnabled() {
        return this.scaleDependentRenderingEnabled;
    }

    @Override
    public Layerable setScaleDependentRenderingEnabled(boolean scaleDependentRenderingEnabled) {
        this.modified = true;
        if (this.scaleDependentRenderingEnabled == scaleDependentRenderingEnabled) {
            return this;
        }
        this.scaleDependentRenderingEnabled = scaleDependentRenderingEnabled;
        this.fireAppearanceChanged();
        return this;
    }

    @Override
    public Collection<StyleCollection> getStyleCollections() {
        return Collections.unmodifiableCollection(this.lstStyleCollections);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStyleCollections(Collection<StyleCollection> styleCollections) {
        this.modified = true;
        boolean saveFiringEvents = this.getLayerManager().isFiringEvents();
        try {
            this.getLayerManager().setFiringEvents(false);
            this.lstStyleCollections.clear();
            if (styleCollections != null) {
                for (StyleCollection _styleCollection : styleCollections) {
                    this.addStyleCollection(_styleCollection);
                }
            }
        }
        finally {
            this.getLayerManager().setFiringEvents(saveFiringEvents);
        }
        this.fireAppearanceChanged();
    }

    public final void addStyleCollection(StyleCollection styleCollection) {
        this.modified = true;
        styleCollection.setLayerable(this);
        this.lstStyleCollections.add(styleCollection);
        this.fireAppearanceChanged();
    }

    public void removeStyleCollection(StyleCollection styleCollection) {
        this.modified = true;
        Assert.isTrue((boolean)this.lstStyleCollections.remove(styleCollection));
        this.fireAppearanceChanged();
    }

    public StyleCollection getValidStyleCollection() {
        return this.getStyleCollectionByScale(this.getScreenScale());
    }

    @Override
    public StyleCollection getStyleCollectionByScale(double dblScale) {
        if (!this.isScaleDependentRenderingEnabled()) {
            for (StyleCollection validStyleCollection : this.lstStyleCollections) {
                if (!validStyleCollection.getDefault()) continue;
                return validStyleCollection;
            }
        } else {
            for (StyleCollection validStyleCollection : this.lstStyleCollections) {
                long lngScale;
                if (validStyleCollection.getDefault() || (lngScale = Math.round(dblScale)) <= validStyleCollection.getMinScale().longValue() || lngScale > validStyleCollection.getMaxScale().longValue()) continue;
                return validStyleCollection;
            }
        }
        return null;
    }

    @Override
    public boolean withinVisibleScaleRange() {
        return this.getValidStyleCollection() != null;
    }

    public StyleCollection getDefaultStyleCollection() {
        for (StyleCollection currStyleCollection : this.lstStyleCollections) {
            if (!currStyleCollection.getDefault()) continue;
            return currStyleCollection;
        }
        return null;
    }

    @Override
    public Collection<StyleCollection> cloneStyleCollections() {
        ArrayList<StyleCollection> lstStyleCollectionClone = new ArrayList<StyleCollection>();
        for (StyleCollection currStyleCollection : this.lstStyleCollections) {
            lstStyleCollectionClone.add(currStyleCollection.clone());
        }
        return lstStyleCollectionClone;
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    @Override
    public void setModified(boolean _modified) {
        this.modified = _modified;
    }

    @Override
    public TreePath getTreePath() {
        Category cat = this.getCategory();
        ArrayList<Object> lstTreePath = new ArrayList<Object>();
        if (cat == null) {
            return null;
        }
        while (cat.getParentCategory() != null) {
            cat = cat.getParentCategory();
            lstTreePath.add(0, cat);
        }
        lstTreePath.add(this.getCategory());
        lstTreePath.add(this);
        lstTreePath.set(0, this.getLayerManager());
        Object[] arrTreePath = lstTreePath.toArray();
        return new TreePath(arrTreePath);
    }

    @Override
    public boolean isExportable() {
        return this.exportable;
    }

    @Override
    public void setExportable(boolean exportable) {
        this.modified = true;
        if (this.exportable == exportable) {
            return;
        }
        this.exportable = exportable;
        this.fireLayerChanged(LayerEventType.METADATA_CHANGED);
    }

    @Override
    public boolean isLayerInitialized() {
        return this.layerInitialized;
    }

    @Override
    public void executeForInitialization() throws Exception {
        this.layerInitialized = true;
    }

    @Override
    public boolean displayedTreeNodeContains(String searchValue) {
        return StringUtils.containsIgnoreCase((CharSequence)this.getName(), (CharSequence)searchValue);
    }

    public <T extends StyleModel> T getValidStyle(Class<T> styleClass) {
        StyleCollection sCol = this.getValidStyleCollection();
        return sCol == null ? null : (T)sCol.getStyle(styleClass);
    }

    public <T extends StyleModel> T getDefaultStyle(Class<T> styleClass) {
        StyleCollection sCol = this.getDefaultStyleCollection();
        return sCol.getStyle(styleClass);
    }
}

