/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model;

import com.vividsolutions.jump.workbench.model.CadLayerSymbolDefinition;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.LayerStyleCollection;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.ui.plugin.layer.cad.CadFeatureAtts;
import com.vividsolutions.jump.workbench.ui.renderer.style.RenderUtil;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.riwajump.data.model.DMDCollection;
import de.riwagis.riwajump.data.model.FeaturestoreMetadata;
import de.riwagis.riwajump.model.style.AbstractCadStyleModel;
import de.riwagis.riwajump.model.style.CadStyleModel;
import de.riwagis.riwajump.model.style.StyleModel;
import de.riwagis.riwajump.symbol.SymbolStore;
import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCadLayer
extends Layer {
    public static final Font DEFAULT_FONT = new Font("Liberation Sans", 0, 12);
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCadLayer.class);
    private static final Map<Integer, String> mapLinePatterns = new LinkedHashMap<Integer, String>();
    private static final long serialVersionUID = -7562540064872567262L;
    protected transient SimpleFeature defaultFeature;
    private transient boolean useDefaultFeature = true;
    private transient boolean drawDimension = false;

    public abstract SimpleFeatureType getDefaultFeatureType();

    protected AbstractCadLayer(String name, FeaturestoreMetadata fmd, LayerManager layerManager) {
        super(name, fmd, layerManager);
    }

    @Override
    protected Object readResolve() {
        super.readResolve();
        this.useDefaultFeature = true;
        return this;
    }

    @Override
    public AbstractCadLayer clone() throws CloneNotSupportedException {
        return (AbstractCadLayer)super.clone();
    }

    public static List<String> getDefaultLinePatterns() {
        Iterator<Integer> i = mapLinePatterns.keySet().iterator();
        ArrayList<String> lstLinePatterns = new ArrayList<String>();
        while (i.hasNext()) {
            lstLinePatterns.add(mapLinePatterns.get(i.next()));
        }
        return lstLinePatterns;
    }

    protected SimpleFeature initDefaultFeature() {
        try {
            SimpleFeature defaultStyle = FeatureUtil.createFeature((SimpleFeatureType)this.getDefaultFeatureType());
            FeatureUtil.setAttribute((SimpleFeature)defaultStyle, (String)CadFeatureAtts.NAME.getName(), null);
            FeatureUtil.setAttribute((SimpleFeature)defaultStyle, (String)CadFeatureAtts.TEXT.getName(), null);
            FeatureUtil.setAttribute((SimpleFeature)defaultStyle, (String)CadFeatureAtts.TEXTORI.getName(), (Object)0.0);
            FeatureUtil.setAttribute((SimpleFeature)defaultStyle, (String)CadFeatureAtts.TEXTSIZE.getName(), (Object)Float.valueOf(10.0f));
            FeatureUtil.setAttribute((SimpleFeature)defaultStyle, (String)CadFeatureAtts.TEXTCOLOR.getName(), (Object)Color.RED.getRGB());
            FeatureUtil.setAttribute((SimpleFeature)defaultStyle, (String)CadFeatureAtts.TEXTFONT.getName(), (Object)DEFAULT_FONT.getFamily());
            FeatureUtil.setAttribute((SimpleFeature)defaultStyle, (String)CadFeatureAtts.SYMSIZE.getName(), (Object)Float.valueOf(20.0f));
            FeatureUtil.setAttribute((SimpleFeature)defaultStyle, (String)CadFeatureAtts.SYMORI.getName(), (Object)0.0);
            FeatureUtil.setAttribute((SimpleFeature)defaultStyle, (String)CadFeatureAtts.LINEPATTERN.getName(), (Object)"");
            FeatureUtil.setAttribute((SimpleFeature)defaultStyle, (String)CadFeatureAtts.LINEWIDTH.getName(), (Object)Float.valueOf(1.0f));
            FeatureUtil.setAttribute((SimpleFeature)defaultStyle, (String)CadFeatureAtts.FILLWIDTH.getName(), (Object)20);
            FeatureUtil.setAttribute((SimpleFeature)defaultStyle, (String)CadFeatureAtts.LINECOLOR.getName(), (Object)Color.RED.getRGB());
            FeatureUtil.setAttribute((SimpleFeature)defaultStyle, (String)CadFeatureAtts.FILLCOLOR.getName(), (Object)Color.RED.getRGB());
            FeatureUtil.setAttribute((SimpleFeature)defaultStyle, (String)CadFeatureAtts.RENDERFILL.getName(), (Object)1);
            FeatureUtil.setAttribute((SimpleFeature)defaultStyle, (String)CadFeatureAtts.ALPHA.getName(), (Object)100);
            FeatureUtil.setAttribute((SimpleFeature)defaultStyle, (String)CadFeatureAtts.MTYPE.getName(), (Object)0);
            FeatureUtil.setAttribute((SimpleFeature)defaultStyle, (String)CadFeatureAtts.MTEXT.getName(), null);
            FeatureUtil.setAttribute((SimpleFeature)defaultStyle, (String)CadFeatureAtts.MTEXT_ORI.getName(), (Object)0.0);
            FeatureUtil.setAttribute((SimpleFeature)defaultStyle, (String)CadFeatureAtts.USE_ORI.getName(), (Object)0);
            FeatureUtil.setAttribute((SimpleFeature)defaultStyle, (String)CadFeatureAtts.ALPHA.getName(), (Object)150);
            return defaultStyle;
        }
        catch (Exception e) {
            LOG.error(String.format("Error initializing defaultFeature in AbstractCadLayer: %s", this.getName()), (Throwable)e);
            return null;
        }
    }

    @Override
    public StyleCollection createNewDefaultStyleCollection() {
        LayerStyleCollection styleCollection = new LayerStyleCollection(this, true);
        styleCollection.addStyle((StyleModel)new CadStyleModel());
        styleCollection.setDefault(true);
        return styleCollection;
    }

    @Override
    public FeaturestoreMetadata getFMD() {
        return this.adjustFmd(super.getFMD());
    }

    @Override
    public void setFMD(FeaturestoreMetadata fmd) {
        super.setFMD(this.adjustFmd(fmd));
    }

    private FeaturestoreMetadata adjustFmd(FeaturestoreMetadata fmd) {
        try {
            if (fmd == null) {
                return null;
            }
            DMDCollection dmdCol = this.getDMDCol();
            if (dmdCol == null) {
                return fmd;
            }
            if (StringUtils.isEmpty((CharSequence)fmd.getDatastoreName())) {
                return fmd;
            }
            SimpleFeatureType fType = fmd.getSchema(this.getDMDCol());
            if (FeatureUtil.hasAttributeDescriptor((SimpleFeatureType)fType, (String)CadFeatureAtts.SYMORI.getName())) {
                fmd.setOriAtt(FeatureUtil.getAttributeDescriptor((SimpleFeatureType)fType, (String)CadFeatureAtts.SYMORI.getName()).getLocalName());
            } else {
                fmd.setOriAtt(null);
            }
            if (FeatureUtil.hasAttributeDescriptor((SimpleFeatureType)fType, (String)CadFeatureAtts.TEXT.getName())) {
                fmd.setUseText(true);
                fmd.setTextAtt(FeatureUtil.getAttributeDescriptor((SimpleFeatureType)fType, (String)CadFeatureAtts.TEXT.getName()).getLocalName());
                if (FeatureUtil.hasAttributeDescriptor((SimpleFeatureType)fType, (String)CadFeatureAtts.TEXTORI.getName())) {
                    fmd.setTextOriAtt(FeatureUtil.getAttributeDescriptor((SimpleFeatureType)fType, (String)CadFeatureAtts.TEXTORI.getName()).getLocalName());
                }
            } else {
                fmd.setUseText(false);
                fmd.setTextAtt(null);
                fmd.setTextOriAtt(null);
            }
        }
        catch (IOException | RuntimeException e) {
            LOG.warn("Error adjusting FeaturestoreMetadata in AbstractCadLayer. Continuing without adjustion.", (Throwable)e);
        }
        return fmd;
    }

    public void setUseDefaultFeature(boolean useDefaultFeature) {
        this.useDefaultFeature = useDefaultFeature;
    }

    public boolean getUseDefaultFeature() {
        return this.useDefaultFeature;
    }

    public void setDrawDimension(boolean drawDimension) {
        this.drawDimension = drawDimension;
    }

    public boolean getDrawDimension() {
        return this.drawDimension;
    }

    public SimpleFeature getDefaultFeature() {
        if (this.defaultFeature == null) {
            this.defaultFeature = this.initDefaultFeature();
        }
        return this.defaultFeature;
    }

    public List<CadLayerSymbolDefinition> getSymbolDefs() {
        return this.getSymbolDefsInternal(false);
    }

    public List<CadLayerSymbolDefinition> getFills() {
        return this.getSymbolDefsInternal(true);
    }

    private List<CadLayerSymbolDefinition> getSymbolDefsInternal(boolean returnFills) {
        SymbolStore symbolStore = this.getSymbolStore();
        if (symbolStore != null) {
            return returnFills ? symbolStore.getFillDefinitions() : symbolStore.getSymbolDefinitions();
        }
        return Collections.emptyList();
    }

    public SymbolStore getSymbolStore() {
        String storeName = this.getSymbolStoreName();
        if (StringUtils.isNotBlank((CharSequence)storeName)) {
            return RenderUtil.getSymbolStore(storeName, this.getLayerManager().getTask());
        }
        return null;
    }

    protected String getSymbolStoreName() {
        StyleCollection sCol = this.getDefaultStyleCollection();
        if (sCol == null) {
            LOG.error("CAD '{}' layer has no default style collection", (Object)this.getName());
            return "_buildIn";
        }
        AbstractCadStyleModel cadStyle = sCol.getStyle(AbstractCadStyleModel.class);
        if (cadStyle == null) {
            LOG.error("CAD '{}' layer has no CAD Style Model", (Object)this.getName());
            return "_buildIn";
        }
        String strSymStore = cadStyle.getStrSymStore();
        if (strSymStore == null) {
            LOG.error("CAD '{}' layer has no symbol store defined", (Object)this.getName());
            return "_buildIn";
        }
        return strSymStore;
    }

    public void copyDefaultStyleToFeature(SimpleFeature target) {
        for (CadFeatureAtts att : CadFeatureAtts.values()) {
            if (!att.isStyle() || !FeatureUtil.hasAttribute((SimpleFeature)this.getDefaultFeature(), (String)att.getName())) continue;
            Object newValue = FeatureUtil.getAttribute((SimpleFeature)this.getDefaultFeature(), (String)att.getName());
            FeatureUtil.setAttribute((SimpleFeature)target, (String)att.getName(), (Object)newValue);
        }
    }

    public void copyStyleToDefaultFeature(SimpleFeature source) {
        for (CadFeatureAtts att : CadFeatureAtts.values()) {
            if (!att.isStyle() || !FeatureUtil.hasAttribute((SimpleFeature)source, (String)att.getName())) continue;
            Object newDefaultValue = FeatureUtil.getAttribute((SimpleFeature)source, (String)att.getName());
            FeatureUtil.setAttribute((SimpleFeature)this.getDefaultFeature(), (String)att.getName(), (Object)newDefaultValue);
        }
    }

    public boolean styleAttributeEquals(SimpleFeature other) {
        SimpleFeature thizz = this.getDefaultFeature();
        for (CadFeatureAtts att : CadFeatureAtts.values()) {
            Object b;
            Object a;
            if (!att.isStyle() || Objects.equals(a = FeatureUtil.getAttribute((SimpleFeature)thizz, (String)att.getName()), b = FeatureUtil.getAttribute((SimpleFeature)other, (String)att.getName()))) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void editFeature(SimpleFeature feat, int action, Collection<SimpleFeature> oldFeatures) throws Exception {
        String strError = this.isFeatureValid(feat, action);
        if (strError != null) {
            throw new Exception(strError);
        }
        if (action == 1) {
            if (this.getUseDefaultFeature()) {
                this.copyDefaultStyleToFeature(feat);
            }
            if (this.drawDimension) {
                FeatureUtil.setAttribute((SimpleFeature)feat, (String)CadFeatureAtts.ISDIM.getName(), (Object)1);
            }
        }
        super.editFeature(feat, action, oldFeatures);
    }

    @Override
    public SimpleFeatureType getFeatureType() {
        return super.getFeatureType();
    }

    static {
        mapLinePatterns.put(0, "");
        mapLinePatterns.put(1, "3");
        mapLinePatterns.put(2, "7");
        mapLinePatterns.put(3, "14");
        mapLinePatterns.put(4, "9,3,2,3");
    }
}

