/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench;

import com.vividsolutions.jump.workbench.WorkbenchProperties;
import com.vividsolutions.jump.workbench.ui.components.ErrorHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class WorkbenchPropertiesFile
implements WorkbenchProperties {
    private final ErrorHandler errorHandler;
    private final Element root;

    public WorkbenchPropertiesFile(File file, ErrorHandler errorHandler) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        Document document = builder.build(file);
        this.root = document.getRootElement();
        this.errorHandler = errorHandler;
    }

    @Override
    public String getTitle() {
        return ObjectUtils.toString((Object)this.root.getChildTextTrim("title"));
    }

    @Override
    public String getHelpUrl() {
        return ObjectUtils.toString((Object)this.root.getChildTextTrim("help"));
    }

    @Override
    public List<Class<?>> getPlugInClasses() {
        ArrayList plugInClasses = new ArrayList();
        for (Object plugInElementObj : this.root.getChildren("plug-in")) {
            Element plugInElement = (Element)plugInElementObj;
            try {
                plugInClasses.add(Class.forName(plugInElement.getTextTrim()));
            }
            catch (ClassNotFoundException e) {
                this.errorHandler.handleThrowable(e);
            }
        }
        return plugInClasses;
    }

    @Override
    public List<Class<?>> getConfigurationClasses() throws ClassNotFoundException {
        ArrayList getConfigurationClasses = new ArrayList();
        for (Object configurationElementObj : this.root.getChildren("extension")) {
            Element configurationElement = (Element)configurationElementObj;
            getConfigurationClasses.add(Class.forName(configurationElement.getTextTrim()));
        }
        return getConfigurationClasses;
    }
}

