/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench;

import com.vividsolutions.jump.workbench.WorkbenchContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.geotools.http.HTTPClient;
import org.geotools.http.HTTPResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkbenchHTTPClient
implements HTTPClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkbenchHTTPClient.class);
    private String user;
    private String password;
    private boolean tryGzip;
    private Credentials credentials;

    public HTTPResponse post(URL url, InputStream postContent, String postContentType) throws IOException {
        RequestBuilder requestBuilder = RequestBuilder.post((String)url.toExternalForm());
        if (postContentType != null) {
            requestBuilder.setHeader("Content-type", postContentType);
        }
        if (this.tryGzip) {
            requestBuilder.setHeader("Accept-Encoding", "gzip");
        }
        requestBuilder.setEntity(EntityBuilder.create().setStream(postContent).build());
        HttpUriRequest request = requestBuilder.build();
        HttpResponse response = this.credentials != null ? WorkbenchContext.executeMethod(request, this.credentials, true) : WorkbenchContext.executeMethod(request);
        if (200 != response.getStatusLine().getStatusCode()) {
            throw new IOException("Server returned HTTP error code " + String.valueOf(response.getStatusLine()) + " for URL " + url.toExternalForm());
        }
        return new HttpMethodResponse(response);
    }

    public HTTPResponse get(URL url) throws IOException {
        RequestBuilder requestBuilder = RequestBuilder.get((String)url.toExternalForm());
        if (this.tryGzip) {
            requestBuilder.setHeader("Accept-Encoding", "gzip");
        }
        HttpUriRequest request = requestBuilder.build();
        HttpResponse response = this.credentials != null ? WorkbenchContext.executeMethod(request, this.credentials, true) : WorkbenchContext.executeMethod(request);
        if (200 != response.getStatusLine().getStatusCode()) {
            throw new IOException("Server returned HTTP error code " + String.valueOf(response.getStatusLine()) + " for URL " + url.toExternalForm());
        }
        return new HttpMethodResponse(response);
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
        this.resetCredentials();
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
        this.resetCredentials();
    }

    public int getConnectTimeout() {
        return 3000;
    }

    public void setConnectTimeout(int connectTimeout) {
    }

    public int getReadTimeout() {
        return 3000;
    }

    public void setReadTimeout(int readTimeout) {
    }

    public boolean isTryGzip() {
        return this.tryGzip;
    }

    public void setTryGzip(boolean tryGZIP) {
        this.tryGzip = tryGZIP;
    }

    private void resetCredentials() {
        this.credentials = StringUtils.isNotBlank((CharSequence)this.user) && StringUtils.isNotBlank((CharSequence)this.password) ? new UsernamePasswordCredentials(this.user, this.password) : null;
    }

    private static class HttpMethodResponse
    implements HTTPResponse {
        private final HttpResponse response;
        private InputStream responseBodyAsStream;

        public HttpMethodResponse(HttpResponse response) {
            this.response = response;
        }

        public void dispose() {
            if (this.responseBodyAsStream != null) {
                try {
                    this.responseBodyAsStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public String getContentType() {
            return this.getResponseHeader("Content-Type");
        }

        public String getResponseHeader(String headerName) {
            Header responseHeader = this.response.getFirstHeader(headerName);
            return responseHeader == null ? null : responseHeader.getValue();
        }

        public InputStream getResponseStream() throws IOException {
            if (this.responseBodyAsStream == null) {
                this.responseBodyAsStream = this.response.getEntity().getContent();
                if (log.isTraceEnabled()) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    this.responseBodyAsStream.transferTo(baos);
                    this.responseBodyAsStream = new ByteArrayInputStream(baos.toByteArray());
                    try (ByteArrayInputStream secondClone = new ByteArrayInputStream(baos.toByteArray());){
                        log.trace("HTTP Request returned response: {}", (Object)new String(((InputStream)secondClone).readAllBytes()));
                    }
                }
            }
            return this.responseBodyAsStream;
        }

        public String getResponseCharset() {
            return this.response.getEntity().getContentEncoding().getValue();
        }
    }
}

