/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench;

import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchHTTPClientFactory;
import com.vividsolutions.jump.workbench.feign.ErasingRequestConfigHttpClient;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.registry.Registry;
import com.vividsolutions.jump.workbench.ui.FeatureTextWriterRegistry;
import com.vividsolutions.jump.workbench.ui.LayerNamePanel;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelProxy;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelProxy;
import com.vividsolutions.jump.workbench.ui.TaskFrameProxy;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.components.ErrorHandler;
import com.vividsolutions.jump.workbench.ui.selection.SelectionManager;
import com.vividsolutions.jump.workbench.ui.selection.SelectionManagerProxy;
import de.riwagis.browser.WindowManager;
import de.riwagis.gis.context.jump.MapAppContextImpl;
import de.riwagis.gis.context.map.MapAppContext;
import de.riwagis.util.http.HTTPClientSupport;
import de.riwagis.util.http.HttpClientConfig;
import de.riwagis.util.http.HttpClientProxyManager;
import feign.Client;
import feign.Feign;
import feign.Logger;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.form.FormEncoder;
import feign.gson.GsonDecoder;
import feign.gson.GsonEncoder;
import feign.httpclient.ApacheHttpClient;
import feign.reactive.ReactorFeign;
import feign.slf4j.Slf4jLogger;
import java.awt.RenderingHints;
import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import javax.swing.JInternalFrame;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HttpContext;
import org.geotools.util.factory.Hints;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkbenchContext
implements LayerViewPanelProxy,
LayerNamePanelProxy,
LayerManagerProxy,
SelectionManagerProxy {
    private static final Logger LOG = LoggerFactory.getLogger(WorkbenchContext.class);
    private static final Lock lock = new ReentrantLock();
    private static MapAppContext mapAppContext = null;
    private static HttpClient client = null;
    private static HttpClientProxyManager clientProxyManager = null;
    private final Registry registry = new Registry();
    private final FeatureTextWriterRegistry featureTextWriterRegistry = new FeatureTextWriterRegistry();
    private static final ConcurrentHashMap<Class<?>, Object> restApis = new ConcurrentHashMap();

    WorkbenchContext() {
    }

    public static void checkClient() {
        block5: {
            lock.lock();
            try {
                if (client != null) break block5;
                client = HTTPClientSupport.generateHttpClient((HttpClientConfig)HttpClientConfig.builder().socketTimeoutInMillis(60000).connTimeoutInMillis(5000).parallelConnections(20).build());
                try {
                    clientProxyManager = new HttpClientProxyManager();
                }
                catch (Exception e) {
                    WorkbenchContext.getFrame().handleThrowable(e);
                }
                Hints.putSystemDefault((RenderingHints.Key)Hints.HTTP_CLIENT_FACTORY, WorkbenchHTTPClientFactory.class);
            }
            finally {
                lock.unlock();
            }
        }
    }

    public static HttpClient getClient() {
        WorkbenchContext.checkClient();
        Objects.requireNonNull(client);
        return client;
    }

    public static <T> T getInterface(Class<T> apiType) {
        return WorkbenchContext.getInterface(apiType, Feign.builder(), WindowManager.getInstance().getWebgisForwardProxy());
    }

    public static <T> T getReactiveInterface(Class<T> apiType) {
        return WorkbenchContext.getInterface(apiType, (Feign.Builder)ReactorFeign.builder(), WindowManager.getInstance().getWebgisForwardProxy());
    }

    public static <T> T getInterface(Class<T> apiType, Feign.Builder builder, URI baseAddress) {
        WorkbenchContext.checkClient();
        return (T)restApis.computeIfAbsent(apiType, o -> builder.client((Client)new ApacheHttpClient((HttpClient)new ErasingRequestConfigHttpClient(clientProxyManager, WorkbenchContext.getClient()))).encoder((Encoder)new FormEncoder((Encoder)new GsonEncoder())).decoder((Decoder)new GsonDecoder()).logger((feign.Logger)new Slf4jLogger()).logLevel(Logger.Level.FULL).target(apiType, baseAddress.toString()));
    }

    public static <T> T getInterface(Class<T> apiType, Feign.Builder builder, String url, Consumer<Feign.Builder> customizer) {
        WorkbenchContext.checkClient();
        Feign.Builder b = builder.client((Client)new ApacheHttpClient((HttpClient)new ErasingRequestConfigHttpClient(clientProxyManager, WorkbenchContext.getClient()))).encoder((Encoder)new FormEncoder((Encoder)new GsonEncoder())).decoder((Decoder)new GsonDecoder()).logger((feign.Logger)new Slf4jLogger()).logLevel(Logger.Level.FULL);
        customizer.accept(b);
        return (T)b.target(apiType, url);
    }

    public static MapAppContext getMapAppContext() {
        if (mapAppContext == null) {
            mapAppContext = new MapAppContextImpl();
        }
        return mapAppContext;
    }

    public static WorkbenchContext getInstance() {
        return JUMPWorkbench.getContext();
    }

    public static JUMPWorkbench getWorkbench() {
        return JUMPWorkbench.getWorkbench();
    }

    public static Blackboard getBlackboard() {
        return JUMPWorkbench.getBlackboard();
    }

    public static HttpResponse executeMethod(HttpUriRequest httpRequest) throws IOException {
        return WorkbenchContext.executeMethod(httpRequest, null);
    }

    public static HttpResponse executeMethod(HttpUriRequest httpRequest, Credentials creds) throws IOException {
        return WorkbenchContext.executeMethod(httpRequest, creds, true);
    }

    public static HttpResponse executeMethod(HttpUriRequest httpRequest, Credentials creds, boolean preemptiveAuth) throws IOException {
        WorkbenchContext.checkClient();
        try {
            URI requestURI = httpRequest.getURI();
            HttpClientContext httpContext = clientProxyManager.getHttpClientContext(new URI(requestURI.getScheme(), null, requestURI.getHost(), requestURI.getPort(), "", "", ""));
            if (creds != null) {
                CredentialsProvider credentialsProvider = httpContext.getCredentialsProvider();
                if (credentialsProvider == null) {
                    credentialsProvider = new BasicCredentialsProvider();
                    httpContext.setCredentialsProvider(credentialsProvider);
                }
                AuthScope authScope = new AuthScope(requestURI.getHost(), requestURI.getPort(), AuthScope.ANY_REALM, AuthScope.ANY_SCHEME);
                credentialsProvider.setCredentials(authScope, creds);
                if (preemptiveAuth) {
                    LOG.trace("Using preemptive auth to {} with principal {}", (Object)requestURI, (Object)creds.getUserPrincipal());
                    BasicAuthCache authCache = new BasicAuthCache();
                    authCache.put(new HttpHost(requestURI.getHost(), requestURI.getPort(), requestURI.getScheme()), (AuthScheme)new BasicScheme());
                    httpContext.setAuthCache((AuthCache)authCache);
                }
            }
            return client.execute(httpRequest, (HttpContext)httpContext);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static ErrorHandler getErrorHandler() {
        return JUMPWorkbench.getFrame();
    }

    public static Task getTask() {
        if (!(WorkbenchContext.activeInternalFrame() instanceof TaskFrameProxy)) {
            return null;
        }
        return ((TaskFrameProxy)((Object)WorkbenchContext.activeInternalFrame())).getTaskFrame().getTask();
    }

    public static WorkbenchFrame getFrame() {
        return JUMPWorkbench.getFrame();
    }

    private static JInternalFrame activeInternalFrame() {
        if (JUMPWorkbench.getFrame() != null) {
            return JUMPWorkbench.getFrame().getActiveInternalFrame();
        }
        return null;
    }

    @Override
    public LayerNamePanel getLayerNamePanel() {
        if (!(WorkbenchContext.activeInternalFrame() instanceof LayerNamePanelProxy)) {
            return null;
        }
        return ((LayerNamePanelProxy)((Object)WorkbenchContext.activeInternalFrame())).getLayerNamePanel();
    }

    @Override
    public LayerManager getLayerManager() {
        if (!(WorkbenchContext.activeInternalFrame() instanceof LayerManagerProxy)) {
            return null;
        }
        return ((LayerManagerProxy)((Object)WorkbenchContext.activeInternalFrame())).getLayerManager();
    }

    @Override
    public LayerViewPanel getLayerViewPanel() {
        if (!(WorkbenchContext.activeInternalFrame() instanceof LayerViewPanelProxy)) {
            return null;
        }
        return ((LayerViewPanelProxy)((Object)WorkbenchContext.activeInternalFrame())).getLayerViewPanel();
    }

    public PlugInContext createPlugInContext() {
        return new PlugInContext(this, WorkbenchContext.getTask(), this, this.getLayerNamePanel(), this.getLayerViewPanel());
    }

    public FeatureTextWriterRegistry getFeatureTextWriterRegistry() {
        return this.featureTextWriterRegistry;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    @Override
    public SelectionManager getSelectionManager() {
        LayerViewPanel lvp = this.getLayerViewPanel();
        if (lvp != null) {
            return lvp.getSelectionManager();
        }
        return null;
    }

    public void closeHttpClient() {
        lock.lock();
        try {
            if (client != null) {
                ((CloseableHttpClient)client).close();
            }
        }
        catch (Exception exp) {
            LOG.error("Error closing HttpClient", (Throwable)exp);
        }
        finally {
            lock.unlock();
        }
    }
}

