/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.util.commandline.CommandLine;
import com.vividsolutions.jump.util.commandline.OptionSpec;
import com.vividsolutions.jump.util.commandline.ParseException;
import com.vividsolutions.jump.workbench.COpt;
import com.vividsolutions.jump.workbench.JUMPConfiguration;
import com.vividsolutions.jump.workbench.Setup;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.WorkbenchException;
import com.vividsolutions.jump.workbench.WorkbenchProperties;
import com.vividsolutions.jump.workbench.WorkbenchPropertiesFile;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInManager;
import com.vividsolutions.jump.workbench.ui.SplashPanel;
import com.vividsolutions.jump.workbench.ui.SplashWindow;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.intelligence.LegendEntryHeaderIntelligence;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.intelligence.LegendEntryLayerIntelligence;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.intelligence.LegendEntryLayerThemeIntelligence;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.intelligence.LegendEntryLayerableIntelligence;
import com.vividsolutions.jump.workbench.ui.plugin.raster.RasterRenderer;
import com.vividsolutions.jump.workbench.ui.plugin.wms.WMSStyleRenderer;
import com.vividsolutions.jump.workbench.ui.plugin.wmts.WMTSStyleRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.BasicStyleRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.CadRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.ColorThemingRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.DimRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.LineRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.RedlineRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.SymbolRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.TextRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.theming.ThemeRetriever;
import de.riwagis.browser.WindowManager;
import de.riwagis.gis.context.GisContext;
import de.riwagis.icons.IconLoader;
import de.riwagis.riwajump.model.intelligence.JumpModelIntelligence;
import de.riwagis.riwajump.search.intelligence.ListInputIntelligence;
import de.riwagis.riwajump.search.intelligence.RootSearchIntelligence;
import de.riwagis.riwajump.search.intelligence.SubSearchIntelligence;
import de.riwagis.service.directory.DirectoryService;
import de.riwagis.service.directory.ProjectType;
import de.riwagis.util.Config;
import de.riwagis.util.Support;
import de.riwagis.util.file.FileSupport;
import de.riwagis.util.gui.LaFHelper;
import de.riwagis.util.logging.LogSupport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.fonts.FontFace;
import net.sf.jasperreports.engine.fonts.FontFamily;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JUMPWorkbench {
    private static final String ICON_VIEWER = "app-icon-viewer.ico";
    private static final String ICON_AUTHOR = "app-icon-author.ico";
    private static final Logger LOG = LoggerFactory.getLogger(JUMPWorkbench.class);
    private static ImageIcon splashImage;
    public static final File USERPROFILE;
    public static final File JUMP_DIR_OLD;
    public static GisContext GIS_CONTEXT;
    private static String VERSION_TEXT;
    public static final String PROPERTIES_OPTION;
    public static final String PLUG_IN_DIRECTORY_OPTION;
    public static final String I18N_FILE = "i18n";
    public static final String INITIAL_PROJECT_FILE = "project";
    public static final String INITIAL_USE_VIEWER = "viewer";
    public static String I18N_SETLOCALE;
    private static final Class<?> progressMonitorClass;
    private static WorkbenchFrame FRAME;
    private static JUMPWorkbench WORKBENCH;
    private static WorkbenchContext CONTEXT;
    private static final Blackboard BLACKBOARD;
    private static PlugInManager PLUGIN_MANAGER;
    private static CommandLine commandLine;
    private static String title;
    private final WorkbenchProperties dummyProperties;
    private WorkbenchProperties properties;
    private static final Map<Class<?>, PlugIn> classToBuiltInPlugInMap;
    private final List<ActionListener> lstAppCloseListeners;
    public static final Collection<Class<? extends JumpModelIntelligence>> REGISTER_INTELLIGENCE_CLASSES;

    public static ImageIcon splashImage() {
        if (splashImage == null) {
            splashImage = COpt.VIEWER ? IconLoader.image((String)"splash_viewer") : IconLoader.image((String)"splash");
        }
        return splashImage;
    }

    public static String getDisplayVersion() {
        if (VERSION_TEXT != null) {
            return VERSION_TEXT;
        }
        try {
            String frontendVersion = JUMPWorkbench.getVersionFromFile("/version.properties");
            if (frontendVersion != null) {
                LOG.info("Frontend Version: {}", (Object)frontendVersion);
            } else {
                LOG.info("Frontend Version missing. Probably standalone mode");
            }
            String internalVersion = JUMPWorkbench.getVersionFromFile("/jump_version.properties");
            LOG.info("Internal JUMP Version: {}", (Object)internalVersion);
            VERSION_TEXT = Objects.requireNonNullElse(frontendVersion, internalVersion);
            return VERSION_TEXT;
        }
        catch (IOException ex) {
            throw new IllegalStateException("Could not retrieve application version", ex);
        }
    }

    private static String getVersionFromFile(String file) throws IOException {
        InputStream fileStream = JUMPWorkbench.class.getResourceAsStream(file);
        if (fileStream == null) {
            return null;
        }
        Properties props = new Properties();
        props.load(fileStream);
        return props.getProperty("version.text");
    }

    private JUMPWorkbench(String[] args, final JWindow s, TaskMonitor monitor) throws Exception {
        File extensionsDirectory;
        this.properties = this.dummyProperties = new WorkbenchProperties(this){

            @Override
            public List<Class<?>> getPlugInClasses() {
                return new ArrayList();
            }

            @Override
            public String getHelpUrl() {
                return "";
            }

            @Override
            public String getTitle() {
                return "";
            }

            @Override
            public List<Class<?>> getConfigurationClasses() {
                return new ArrayList();
            }

            public boolean getUseProxy(String strHost) {
                return false;
            }
        };
        this.lstAppCloseListeners = new ArrayList<ActionListener>();
        this.createApplicationDirectories();
        WORKBENCH = this;
        if (commandLine.hasOption(I18N_FILE)) {
            I18N.loadFile(commandLine.getOption(I18N_FILE).getArg(0));
            I18N_SETLOCALE = commandLine.getOption(I18N_FILE).getArg(0);
            Config.LOCALE = de.riwagis.util.i18n.I18N.getLocale((String)I18N_SETLOCALE);
        }
        CONTEXT = new WorkbenchContext();
        if (commandLine.hasOption(PROPERTIES_OPTION)) {
            propertiesFile = new File(commandLine.getOption(PROPERTIES_OPTION).getArg(0));
            if (propertiesFile.exists()) {
                this.properties = new WorkbenchPropertiesFile(propertiesFile, FRAME);
            } else {
                LOG.warn("JUMP: Warning: Properties file does not exist: {}", (Object)propertiesFile);
            }
        } else {
            propertiesFile = new File("workbench-properties.xml");
            if (propertiesFile.exists()) {
                this.properties = new WorkbenchPropertiesFile(propertiesFile, FRAME);
            }
        }
        String strTempTitle = this.properties.getTitle();
        if (strTempTitle != null && strTempTitle.length() > 0) {
            title = strTempTitle;
        }
        FRAME = new WorkbenchFrame(title, CONTEXT);
        FRAME.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                s.setVisible(false);
            }

            @Override
            public void windowClosing(WindowEvent e) {
                JUMPWorkbench.this.this_onAppClose();
            }
        });
        if (commandLine.hasOption(INITIAL_PROJECT_FILE)) {
            String task = commandLine.getOption(INITIAL_PROJECT_FILE).getArg(0);
            JUMPWorkbench.getBlackboard().put(INITIAL_PROJECT_FILE, task);
        }
        if (commandLine.hasOption(PLUG_IN_DIRECTORY_OPTION)) {
            extensionsDirectory = new File(commandLine.getOption(PLUG_IN_DIRECTORY_OPTION).getArg(0));
            if (!extensionsDirectory.exists()) {
                LOG.warn(String.format("JUMP: Warning: Extensions directory does not exist: '%s'", extensionsDirectory));
                extensionsDirectory = null;
            }
        } else {
            extensionsDirectory = new File(I18N.get("JUMPWorkbench.lib-ext"));
            if (!extensionsDirectory.exists()) {
                extensionsDirectory = null;
            }
        }
        PLUGIN_MANAGER = new PlugInManager(CONTEXT, extensionsDirectory, monitor);
        ToolTipManager.sharedInstance().setDismissDelay(60000);
    }

    public static String getTitle() {
        if (COpt.VIEWER) {
            return I18N.get("JUMPWorkbench.jump-viewer");
        }
        return I18N.get("JUMPWorkbench.jump");
    }

    public void addCloseAppListener(ActionListener listener) {
        this.lstAppCloseListeners.add(listener);
    }

    public void removeCloseAppListener(ActionListener listener) {
        this.lstAppCloseListeners.remove(listener);
    }

    public WorkbenchProperties getProperties() {
        return this.properties;
    }

    public static WorkbenchFrame getFrame() {
        return FRAME;
    }

    public static JUMPWorkbench getWorkbench() {
        return WORKBENCH;
    }

    public static WorkbenchContext getContext() {
        return CONTEXT;
    }

    private void createApplicationDirectories() {
        File jumpDir = DirectoryService.getInstance().getProjectDirectory(ProjectType.JUMP);
        File tmpDir = DirectoryService.getInstance().getProjectTempDirectory(ProjectType.JUMP);
        File cacheDir = DirectoryService.getInstance().getProjectCacheDirectory(ProjectType.JUMP);
        File settingsDir = new File(DirectoryService.getInstance().getApplicationDataDirectory(), ProjectType.JUMP.getDirectoryName());
        try {
            if (!jumpDir.exists()) {
                jumpDir.mkdirs();
            }
            if (!tmpDir.exists()) {
                tmpDir.mkdirs();
            }
            if (!cacheDir.exists()) {
                cacheDir.mkdirs();
            }
            if (!settingsDir.exists()) {
                settingsDir.mkdirs();
            }
        }
        catch (Exception e) {
            LOG.warn("error: cannot create user and tempdir");
        }
    }

    private static void parseCommandLine(String[] args) throws WorkbenchException {
        commandLine = new CommandLine('-');
        commandLine.addOptionSpec(new OptionSpec(PROPERTIES_OPTION, 1));
        commandLine.addOptionSpec(new OptionSpec(PLUG_IN_DIRECTORY_OPTION, 1));
        commandLine.addOptionSpec(new OptionSpec(I18N_FILE, 1));
        commandLine.addOptionSpec(new OptionSpec(INITIAL_PROJECT_FILE, 1));
        commandLine.addOptionSpec(new OptionSpec(INITIAL_USE_VIEWER, 0));
        try {
            commandLine.parse(args);
        }
        catch (ParseException e) {
            throw new WorkbenchException("A problem occurred parsing the command line: " + e.toString());
        }
    }

    public static PlugInManager getPlugInManager() {
        return PLUGIN_MANAGER;
    }

    static void addBuiltInPlugInClass(Class<?> cls, PlugIn obj) {
        classToBuiltInPlugInMap.put(cls, obj);
    }

    public static <T> T getBuiltInPlugIn(Class<T> cls) {
        return (T)classToBuiltInPlugInMap.get(cls);
    }

    public static List<PlugIn> getAllBuiltInPlugIns() {
        ArrayList<PlugIn> lstPlugIn = new ArrayList<PlugIn>();
        for (Class<?> plugInClass : classToBuiltInPlugInMap.keySet()) {
            lstPlugIn.add(classToBuiltInPlugInMap.get(plugInClass));
        }
        return lstPlugIn;
    }

    private void this_onAppClose() {
        for (ActionListener listener : this.lstAppCloseListeners) {
            listener.actionPerformed(null);
        }
        File tmpDir = DirectoryService.getInstance().getProjectTempDirectory(ProjectType.JUMP);
        FileSupport.cleanDirectory((File)tmpDir, (long)0L, (boolean)true);
    }

    public static Blackboard getBlackboard() {
        return BLACKBOARD;
    }

    private static void initializeLogging() {
        try {
            if (GIS_CONTEXT == null || GIS_CONTEXT.getModuleApp().getLogDir() == null) {
                String log4JFilePath = "log4gis2.xml";
                File log4JFile = new File("log4gis2.xml");
                if (log4JFile.exists()) {
                    File logDir = DirectoryService.getInstance().getProjectLogDirectory(ProjectType.JUMP);
                    if (!logDir.exists()) {
                        logDir.mkdirs();
                    }
                    System.setProperty("application.logdir", String.valueOf(logDir) + File.separator);
                    LogSupport.addXMLConfigurationFile((String)"log4gis2.xml");
                }
            } else {
                DirectoryService.getInstance().setProjectLogDirectory(GIS_CONTEXT.getModuleApp().getLogDir(), ProjectType.JUMP);
            }
        }
        catch (Exception e) {
            LOG.error("Error initializing logging.", (Throwable)e);
        }
    }

    public static void startup(String[] args, GisContext gisContext) {
        GIS_CONTEXT = gisContext;
        JUMPWorkbench.startupWorkbench(args);
    }

    public static void main(String[] args) {
        JUMPWorkbench.startupWorkbench(args);
        WorkbenchContext.getClient();
        SwingUtilities.invokeLater(() -> JUMPWorkbench.getFrame().setVisible(true));
    }

    private static void startupWorkbench(String[] args) {
        try {
            Class.forName("org.geotools.gce.imagemosaic.GranuleDescriptor");
            if (JUMPWorkbench.shouldJumpBeMigrated()) {
                JUMPWorkbench.migrateStateToAppDataDirectory();
            }
            JUMPWorkbench.initializeLogging();
            try {
                JUMPWorkbench.parseCommandLine(args);
                if (commandLine.hasOption(INITIAL_USE_VIEWER)) {
                    COpt.VIEWER = true;
                }
            }
            catch (Throwable e) {
                JUMPWorkbench.blockingShowException(e);
                System.exit(0);
            }
            LaFHelper.initLookAndFeel();
            ProgressMonitor progressMonitor = (ProgressMonitor)progressMonitorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            SplashPanel splashPanel = new SplashPanel(JUMPWorkbench.splashImage(), "<html><div align='right'>" + I18N.get("JUMPWorkbench.version") + " " + JUMPWorkbench.getDisplayVersion() + " / RIWA GmbH</div></html>", true);
            JUMPWorkbench.registerJasperFontsInSwing();
            JUMPWorkbench.main(args, JUMPWorkbench.getTitle(), new JUMPConfiguration(), splashPanel, progressMonitor);
        }
        catch (Throwable t) {
            WorkbenchFrame.handleThrowable(t, null);
        }
    }

    private static void registerJasperFontsInSwing() {
        DefaultJasperReportsContext.getInstance().getExtensions(FontFamily.class).forEach(fam -> {
            JUMPWorkbench.registerJasperFont(fam.getNormalFace());
            JUMPWorkbench.registerJasperFont(fam.getBoldFace());
            JUMPWorkbench.registerJasperFont(fam.getItalicFace());
            JUMPWorkbench.registerJasperFont(fam.getBoldItalicFace());
        });
    }

    private static void registerJasperFont(FontFace normalFace) {
        if (normalFace == null || "JasperReports Icons".equals(normalFace.getName())) {
            return;
        }
        boolean wasRegistered = GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(normalFace.getFont());
        if (wasRegistered) {
            LOG.info("Registered Font {} ", (Object)normalFace.getName());
        } else {
            LOG.debug("Font {} was already registered", (Object)normalFace.getName());
        }
    }

    private static void main(String[] args, String _title, Setup setup, JComponent splashComponent, TaskMonitor taskMonitor) {
        try {
            title = _title;
            JUMPWorkbench.registerJumpModelIntelligences();
            SplashWindow splashWindow = new SplashWindow(splashComponent);
            splashWindow.setVisible(true);
            WORKBENCH = new JUMPWorkbench(args, splashWindow, taskMonitor);
            if (GIS_CONTEXT != null) {
                GIS_CONTEXT.setMapApp(WorkbenchContext.getMapAppContext());
            }
            List icons = COpt.VIEWER ? IconLoader.getIconImagesOfIcoFile((String)ICON_VIEWER) : IconLoader.getIconImagesOfIcoFile((String)ICON_AUTHOR);
            JUMPWorkbench.getFrame().setIconImages(icons);
            WindowManager.getInstance().setWindowIcons(icons);
            setup.setup(CONTEXT);
            JUMPWorkbench.loadBinaries();
            JUMPWorkbench.getPlugInManager().load();
        }
        catch (Throwable t) {
            JUMPWorkbench.blockingShowException(t);
            System.exit(1);
        }
    }

    private static void blockingShowException(Throwable t) {
        try {
            SwingUtilities.invokeAndWait(() -> WorkbenchFrame.handleThrowable(t, null));
        }
        catch (Throwable e) {
            LOG.error("Could not display exception dialog", e);
        }
    }

    public static void registerJumpModelIntelligences() {
        JUMPWorkbench.registerJumpModelIntelligences(REGISTER_INTELLIGENCE_CLASSES);
    }

    public static void registerJumpModelIntelligences(Collection<Class<? extends JumpModelIntelligence>> classes) {
        for (Class<? extends JumpModelIntelligence> currClass : classes) {
            try {
                Class<?> currLoadedClass = Class.forName(currClass.getName());
                LOG.debug("class loaded: " + currLoadedClass.getName());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(String.format("Class not found: '%s'", currClass.getName()), e);
            }
        }
    }

    private static void loadBinaries() {
        if (!Support.isWindows()) {
            return;
        }
        String[] loadPriorities = new String[]{"libwinpthread", "libgcc", "libiconv", "liblzma", "libproj", "libsqlite", "zlib", "libstdc", "libgeos-", "libgeos_", "libfree", "libxml", "librttopo", "mod_spatialite"};
        File dllDir = new File("dll");
        if (dllDir.exists()) {
            SuffixFileFilter fileDLLFilter = new SuffixFileFilter(".dll");
            ArrayList<File> dllFiles = new ArrayList<File>(Arrays.asList(dllDir.listFiles((FileFilter)fileDLLFilter)));
            Iterator<File> it = dllFiles.iterator();
            block0: while (it.hasNext()) {
                File dllFile = it.next();
                String[] stringArray = loadPriorities;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String filename = stringArray[i];
                    if (!dllFile.getName().contains(filename)) continue;
                    it.remove();
                    continue block0;
                }
            }
            for (File file : dllFiles) {
                System.load(file.getAbsolutePath());
                LOG.info(file.getName() + " loaded");
            }
            for (String filename : loadPriorities) {
                File[] files;
                WildcardFileFilter fileFilter = new WildcardFileFilter(filename + "*.dll");
                for (File dllFile : files = dllDir.listFiles((FileFilter)fileFilter)) {
                    System.load(dllFile.getAbsolutePath());
                    LOG.debug(dllFile.getName() + " loaded");
                }
            }
        }
    }

    private static boolean shouldJumpBeMigrated() {
        File sharedFiles = new File(DirectoryService.getInstance().getApplicationDataDirectory(), ProjectType.JUMP.getDirectoryName());
        File localFiles = DirectoryService.getInstance().getProjectDirectory(ProjectType.JUMP);
        return !sharedFiles.exists() && !localFiles.exists() && JUMP_DIR_OLD.exists();
    }

    private static void migrateStateToAppDataDirectory() {
        try {
            boolean tmpExists = false;
            File localAppDirectory = DirectoryService.getInstance().getApplicationDataLocalDirectory();
            File sharedAppDirectory = DirectoryService.getInstance().getApplicationDataDirectory();
            File TEMPDIR = new File(localAppDirectory, "temp");
            if (!TEMPDIR.exists()) {
                tmpExists = TEMPDIR.mkdirs();
            }
            if (tmpExists) {
                File[] workbenchFiles;
                File[] files;
                File newProxyFile;
                FileUtils.copyDirectory((File)JUMP_DIR_OLD, (File)new File(TEMPDIR, ProjectType.JUMP.getDirectoryName()));
                File ALLUSERSPROFILE = new File(StringUtils.defaultString((String)System.getenv("ALLUSERSPROFILE"), (String)System.getProperty("user.home")));
                File proxyDir = new File(ALLUSERSPROFILE, ".proxy");
                if (proxyDir.exists() && !(newProxyFile = DirectoryService.getInstance().getProjectProxyDirectory()).exists()) {
                    FileUtils.copyDirectory((File)proxyDir, (File)newProxyFile);
                }
                for (File file : files = TEMPDIR.listFiles()) {
                    if (!file.isDirectory()) continue;
                    FileUtils.moveDirectoryToDirectory((File)file, (File)localAppDirectory, (boolean)false);
                }
                Files.delete(TEMPDIR.toPath());
                for (File file : workbenchFiles = DirectoryService.getInstance().getProjectDirectory(ProjectType.JUMP).listFiles()) {
                    if (!file.getName().contains("workbench")) continue;
                    FileUtils.moveFileToDirectory((File)file, (File)new File(sharedAppDirectory, ProjectType.JUMP.getDirectoryName()), (boolean)true);
                }
            } else {
                LOG.error("Project temp directory could not be created!");
            }
        }
        catch (IOException ex) {
            LOG.error(String.format("Migration of application data failed: %s", ex.getMessage()));
        }
    }

    public static boolean gisContextAvailable() {
        return GIS_CONTEXT != null;
    }

    public static Optional<GisContext> getGisContext() {
        return Optional.ofNullable(GIS_CONTEXT);
    }

    static {
        USERPROFILE = new File(StringUtils.defaultString((String)System.getenv("USERPROFILE"), (String)System.getProperty("user.home")));
        JUMP_DIR_OLD = new File(USERPROFILE, ".jump");
        GIS_CONTEXT = null;
        PROPERTIES_OPTION = I18N.get("JUMPWorkbench.properties");
        PLUG_IN_DIRECTORY_OPTION = I18N.get("JUMPWorkbench.plug-in-directory");
        I18N_SETLOCALE = "";
        progressMonitorClass = SingleLineProgressMonitor.class;
        WORKBENCH = null;
        CONTEXT = null;
        BLACKBOARD = new Blackboard();
        title = JUMPWorkbench.getTitle();
        classToBuiltInPlugInMap = new HashMap();
        REGISTER_INTELLIGENCE_CLASSES = Arrays.asList(ListInputIntelligence.class, RootSearchIntelligence.class, SubSearchIntelligence.class, WMSStyleRenderer.class, WMTSStyleRenderer.class, TextRenderer.class, SymbolRenderer.class, BasicStyleRenderer.class, LineRenderer.class, ColorThemingRenderer.class, ThemeRetriever.class, DimRenderer.class, CadRenderer.class, RedlineRenderer.class, RasterRenderer.class, LegendEntryHeaderIntelligence.class, LegendEntryLayerIntelligence.class, LegendEntryLayerThemeIntelligence.class, LegendEntryLayerableIntelligence.class);
    }

    private static abstract class ProgressMonitor
    extends JPanel
    implements TaskMonitor {
        private static final long serialVersionUID = -6283464658715063547L;
        private final Component component;

        ProgressMonitor(Component component) {
            this.component = component;
            this.setLayout(new BorderLayout());
            this.add(component, "Center");
            this.setOpaque(false);
        }

        protected Component getComponent() {
            return this.component;
        }

        protected abstract void addText(String var1);

        @Override
        public void report(String description) {
            this.addText(description);
        }

        @Override
        public void report(int itemsDone, int totalItems, String itemDescription) {
            this.addText(String.format("%s / %s %s", itemsDone, totalItems, itemDescription));
        }

        @Override
        public void report(Exception exception) {
            this.addText(StringUtil.toFriendlyName(exception.getClass().getName()));
        }

        @Override
        public void allowCancellationRequests() {
        }

        @Override
        public boolean isCancelRequested() {
            return false;
        }
    }

    private static class SingleLineProgressMonitor
    extends ProgressMonitor {
        private static final long serialVersionUID = 6298840246266349754L;

        SingleLineProgressMonitor() {
            super(new JLabel(" "));
            ((JLabel)this.getComponent()).setFont(((JLabel)this.getComponent()).getFont().deriveFont(1));
            ((JLabel)this.getComponent()).setHorizontalAlignment(2);
        }

        @Override
        protected void addText(String s) {
            ((JLabel)this.getComponent()).setText(s);
        }
    }

    private static class HorizontallyScrollingProgressMonitor
    extends ProgressMonitor {
        private static final String BUFFER = "   ";
        private static final long serialVersionUID = -3910596126331972650L;

        HorizontallyScrollingProgressMonitor() {
            super(new JLabel(" "));
            ((JLabel)this.getComponent()).setFont(((JLabel)this.getComponent()).getFont().deriveFont(1));
            ((JLabel)this.getComponent()).setHorizontalAlignment(4);
        }

        @Override
        protected void addText(String s) {
            ((JLabel)this.getComponent()).setText(BUFFER + s + ((JLabel)this.getComponent()).getText());
        }
    }

    private static class VerticallyScrollingProgressMonitor
    extends ProgressMonitor {
        private static final int ROWS = 3;
        private static final long serialVersionUID = 7795208312749804125L;
        private final JLabel[] labels;

        VerticallyScrollingProgressMonitor() {
            super(new JPanel(new GridLayout(3, 1)));
            JPanel panel = (JPanel)this.getComponent();
            panel.setOpaque(false);
            this.labels = new JLabel[3];
            for (int i = 0; i < 3; ++i) {
                this.labels[i] = new JLabel(" ");
                this.labels[i].setFont(this.labels[i].getFont().deriveFont(1));
                panel.add(this.labels[i]);
            }
        }

        @Override
        protected void addText(String s) {
            for (int i = 0; i < 2; ++i) {
                this.labels[i].setText(this.labels[i + 1].getText());
            }
            this.labels[2].setText(s);
        }
    }
}

