/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import de.riwagis.gis.context.map.debug.DebugInformation;
import de.riwagis.gis.context.map.debug.DebugInformationProvider;
import de.riwagis.gis.context.map.debug.DebugInformations;
import de.riwagis.service.directory.DirectoryService;
import de.riwagis.service.directory.ProjectType;
import de.riwagis.util.gui.highdpi.HighDpiSupport;
import de.riwagis.util.http.HttpClientProxyConfig;
import java.awt.DisplayMode;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class JUMPDebugInformationProvider
implements DebugInformationProvider {
    private static final int MEBIBYTE = 0x100000;
    private static final DecimalFormat MEMORY_FORMAT = new DecimalFormat("###,### MiB");

    public Set<DebugInformation> provide() {
        HashSet<DebugInformation> data = new HashSet<DebugInformation>();
        DirectoryService directoryService = DirectoryService.getInstance();
        Runtime runtime = Runtime.getRuntime();
        long totalMem = runtime.totalMemory();
        long freeMem = runtime.freeMemory();
        long maxMemory = runtime.maxMemory();
        File proxyFile = HttpClientProxyConfig.getProxyFile();
        data.add(this.createDebugInfo("jump.version", JUMPWorkbench.getDisplayVersion()));
        data.add(this.createDebugInfo("jump.directory-base", directoryService.getProjectDirectory(ProjectType.JUMP)));
        data.add(this.createDebugInfo("jump.directory-cache", directoryService.getProjectCacheDirectory(ProjectType.JUMP)));
        data.add(this.createDebugInfo("jump.directory-temp", directoryService.getProjectTempDirectory(ProjectType.JUMP)));
        data.add(this.createDebugInfo("jump.directory-log", directoryService.getProjectLogDirectory(ProjectType.JUMP)));
        data.add(this.createDebugInfo("jump.configuration-base", PersistentBlackboardPlugIn.getConfigurationFile()));
        data.add(this.createDebugInfo("jump.geotools-epsg-db", this.getGeoToolsEpsgHsqlDataBaseDirectory()));
        data.add(this.createDebugInfo("webgis.proxy-configuration-directory", directoryService.getProjectProxyDirectory()));
        data.add(this.createDebugInfo("webgis.proxy-configuration-file", proxyFile));
        data.add(this.createDebugInfo("webgis.proxy-in-use", this.localizeBoolean(this.isProxyInUse(proxyFile))));
        data.add(this.createDebugInfo("webgis.executable-directory", Path.of(System.getProperty("launch4j.exedir", ""), new String[0])));
        data.add(this.createDebugInfo("webgis.executable-name", FilenameUtils.getName((String)System.getProperty("launch4j.exefile"))));
        data.add(this.createDebugInfo("java.properties", StringUtils.join((Object[])new Properties[]{System.getProperties()})));
        data.add(this.createDebugInfo("java.version", this.getJavaVersion()));
        data.add(this.createDebugInfo("java.home", Path.of(System.getProperty("java.home"), new String[0])));
        data.add(this.createDebugInfo("system.variables", StringUtils.join((Object[])new Map[]{System.getenv()})));
        data.add(this.createDebugInfo("system.os-version", this.getOSVersion()));
        data.add(this.createDebugInfo("system.memory-max", this.formatMemory(maxMemory)));
        data.add(this.createDebugInfo("system.memory-total", this.formatMemory(totalMem)));
        data.add(this.createDebugInfo("system.memory-used", this.formatMemory(totalMem - freeMem)));
        data.add(this.createDebugInfo("system.memory-free", this.formatMemory(freeMem)));
        data.add(this.createDebugInfo("system.processors", runtime.availableProcessors()));
        data.add(this.createDebugInfo("system.username", System.getProperty("user.name")));
        data.add(this.createDebugInfo("system.directory-working", Path.of(System.getProperty("user.dir"), new String[0])));
        data.add(this.createDebugInfo("system.directory-user", Path.of(System.getProperty("user.home"), new String[0])));
        data.add(this.createDebugInfo("system.directory-appdata", directoryService.getApplicationDataDirectory()));
        data.add(this.createDebugInfo("system.directory-localappdata", directoryService.getApplicationDataLocalDirectory()));
        data.add(this.createDebugInfo("system.screen-uiscale", this.getCurrentScaleForWorkbenchFrame()));
        for (Pair<Integer, String> screenInfo : this.getScreenInformations()) {
            data.add(this.createDebugInfo("system.screen-" + String.valueOf(screenInfo.getKey()), "system.screen-X", screenInfo.getValue(), screenInfo.getKey()));
        }
        return data;
    }

    private String getOSVersion() {
        return String.format("%s (%s, %s)", System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"));
    }

    private String getJavaVersion() {
        return String.format("%s (%s %s)", System.getProperty("java.version"), System.getProperty("java.vendor"), System.getProperty("java.runtime.version"));
    }

    private boolean isProxyInUse(File proxyFile) {
        return proxyFile != null && proxyFile.exists() && HttpClientProxyConfig.isProxyDefined((File)proxyFile);
    }

    private List<Pair<Integer, String>> getScreenInformations() {
        ArrayList<Pair<Integer, String>> screenInfos = new ArrayList<Pair<Integer, String>>();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] screenDevices = ge.getScreenDevices();
        for (int screenId = 0; screenId < screenDevices.length; ++screenId) {
            GraphicsDevice screenDevice = screenDevices[screenId];
            GraphicsConfiguration dc = screenDevice.getDefaultConfiguration();
            DisplayMode displayMode = screenDevice.getDisplayMode();
            double screenScaleFactor = dc.getDefaultTransform().getScaleX();
            int screenScale = (int)Math.floor(screenScaleFactor * 100.0);
            screenInfos.add((Pair<Integer, String>)Pair.of((Object)screenId, (Object)String.format("%s(%d%%,%s)", displayMode.toString(), screenScale, screenDevice.getClass().getSimpleName())));
        }
        return screenInfos;
    }

    private String getCurrentScaleForWorkbenchFrame() {
        return (int)Math.floor(HighDpiSupport.getDisplayScaleFactorForDevice((GraphicsConfiguration)JUMPWorkbench.getFrame().getGraphicsConfiguration()) * 100.0) + "%";
    }

    private String formatMemory(long maxMemory) {
        return MEMORY_FORMAT.format(maxMemory / 0x100000L);
    }

    private File getGeoToolsEpsgHsqlDataBaseDirectory() {
        return new File(System.getProperty("java.io.tmpdir", "."), "GeoTools");
    }

    private DebugInformation createDebugInfo(String key, Path value) {
        if (value == null) {
            return DebugInformations.createStringInformation((String)key, (String)this.localizeKey(key, key, new Object[0]), null);
        }
        return DebugInformations.createPathInformation((String)key, (String)this.localizeKey(key, key, new Object[0]), (Path)value);
    }

    private DebugInformation createDebugInfo(String key, File value) {
        if (value == null) {
            return DebugInformations.createStringInformation((String)key, (String)this.localizeKey(key, key, new Object[0]), null);
        }
        return DebugInformations.createFileInformation((String)key, (String)this.localizeKey(key, key, new Object[0]), (File)value);
    }

    private DebugInformation createDebugInfo(String key, Object value) {
        return DebugInformations.createStringInformation((String)key, (String)this.localizeKey(key, key, new Object[0]), (Object)value);
    }

    private DebugInformation createDebugInfo(String key, String i18nKey, Object value, Object ... params) {
        return DebugInformations.createStringInformation((String)key, (String)this.localizeKey(key, i18nKey, params), (Object)value);
    }

    private String localizeKey(String key, String i18nKey, Object ... params) {
        try {
            if (params.length != 0) {
                return I18N.getMessage(this.getClass().getName() + "." + i18nKey, params);
            }
            return I18N.get(this.getClass().getName() + "." + i18nKey);
        }
        catch (Exception e) {
            return key;
        }
    }

    private String localizeBoolean(boolean value) {
        if (value) {
            return I18N.get("com.vividsolutions.jump.workbench.JUMPDebugInformationProvider.yes");
        }
        return I18N.get("com.vividsolutions.jump.workbench.JUMPDebugInformationProvider.no");
    }
}

