/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.warp;

import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.util.CollectionMap;
import com.vividsolutions.jump.warp.Quadrilateral;
import com.vividsolutions.jump.warp.TaggedCoordinate;
import com.vividsolutions.jump.warp.Triangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.util.Assert;

public class Triangulator {
    private final GeometryFactory factory = new GeometryFactory();
    private Collection ignoredVectors = new ArrayList();

    public Map triangleMap(Envelope datasetEnvelope, Collection vectorLineStrings, TaskMonitor monitor) {
        return this.triangleMap(datasetEnvelope, vectorLineStrings, new ArrayList(), new ArrayList(), monitor);
    }

    public Map triangleMap(Envelope datasetEnvelope, Collection vectorLineStrings, Collection sourceHints, Collection destinationHints, TaskMonitor monitor) {
        Quadrilateral destQuad;
        Quadrilateral sourceQuad;
        ArrayList vectorListCopy = new ArrayList(vectorLineStrings);
        this.ignoredVectors = Triangulator.nonVectors(vectorListCopy);
        vectorListCopy.removeAll(this.ignoredVectors);
        Assert.isTrue((!datasetEnvelope.isNull() ? 1 : 0) != 0);
        Envelope sourceEnvelope = new Envelope(datasetEnvelope);
        while (!(this.outlyingVectors(sourceQuad = this.sourceQuad(sourceEnvelope), destQuad = this.destQuad(sourceQuad, vectorListCopy), vectorListCopy).isEmpty() && sourceQuad.verticesOutside(sourceHints).isEmpty() && destQuad.verticesOutside(destinationHints).isEmpty())) {
            sourceEnvelope = sourceQuad.getEnvelope();
        }
        Quadrilateral taggedSourceQuad = this.tag(sourceQuad, destQuad);
        List taggedSourceTriangles = this.triangulate(taggedSourceQuad, Triangulator.taggedVectorVertices(false, vectorListCopy), monitor);
        return this.triangleMap(taggedSourceTriangles);
    }

    public Collection getIgnoredVectors() {
        return Collections.unmodifiableCollection(this.ignoredVectors);
    }

    public static Collection nonVectors(Collection geometries) {
        TreeSet<Geometry> nonVectors = new TreeSet<Geometry>();
        for (Geometry g : geometries) {
            if (Triangulator.vector(g)) continue;
            nonVectors.add(g);
        }
        return nonVectors;
    }

    public static boolean vector(Geometry g) {
        return g.getClass() == LineString.class && ((LineString)g).getNumPoints() == 2;
    }

    private TreeSet outlyingVectors(Quadrilateral sourceQuad, Quadrilateral destQuad, Collection vectors) {
        TreeSet outliers = new TreeSet();
        outliers.addAll(this.toVectors(sourceQuad.verticesOutside(Triangulator.taggedVectorVertices(false, vectors)), false));
        outliers.addAll(this.toVectors(destQuad.verticesOutside(Triangulator.taggedVectorVertices(true, vectors)), true));
        return outliers;
    }

    protected List heightMaximizedTriangles(Triangle PQS, Triangle QRS) {
        List<Triangle> originalTriangles = Arrays.asList(PQS, QRS);
        List alternativeTriangles = this.alternativeTriangles(PQS, QRS);
        if (alternativeTriangles == null) {
            return originalTriangles;
        }
        Triangle t1 = (Triangle)alternativeTriangles.get(0);
        Triangle t2 = (Triangle)alternativeTriangles.get(1);
        if (Math.min(PQS.getMinHeight(), QRS.getMinHeight()) > Math.min(t1.getMinHeight(), t2.getMinHeight())) {
            return originalTriangles;
        }
        return alternativeTriangles;
    }

    protected Triangle triangleContaining(Coordinate p, List triangles) {
        for (Triangle triangle : triangles) {
            if (!triangle.contains(p)) continue;
            return triangle;
        }
        return null;
    }

    protected Coordinate add(Coordinate a, LineString vector) {
        return new Coordinate(a.x + vector.getCoordinateN((int)1).x - vector.getCoordinateN((int)0).x, a.y + vector.getCoordinateN((int)1).y - vector.getCoordinateN((int)0).y);
    }

    protected LineString vectorWithNearestTail(Coordinate x, List vectors) {
        Assert.isTrue((vectors.size() > 0 ? 1 : 0) != 0);
        LineString vectorWithNearestTail = (LineString)vectors.get(0);
        for (LineString candidate : vectors) {
            if (!(candidate.getCoordinateN(0).distance(x) < vectorWithNearestTail.getCoordinateN(0).distance(x))) continue;
            vectorWithNearestTail = candidate;
        }
        return vectorWithNearestTail;
    }

    protected Quadrilateral tag(Quadrilateral sourceQuad, Quadrilateral destQuad) {
        return new Quadrilateral(new TaggedCoordinate(sourceQuad.getP1(), destQuad.getP1()), new TaggedCoordinate(sourceQuad.getP2(), destQuad.getP2()), new TaggedCoordinate(sourceQuad.getP3(), destQuad.getP3()), new TaggedCoordinate(sourceQuad.getP4(), destQuad.getP4()));
    }

    protected List alternativeTriangles(Triangle PQS, Triangle QRS) {
        Quadrilateral quad = this.dissolve(PQS, QRS);
        if (!quad.isConvex()) {
            return null;
        }
        return quad.triangles();
    }

    private Quadrilateral sourceQuad(Envelope datasetEnvelope) {
        double dx = datasetEnvelope.getWidth() * 0.05;
        double dy = datasetEnvelope.getHeight() * 0.05;
        return new Quadrilateral(new Coordinate(datasetEnvelope.getMinX() - dx, datasetEnvelope.getMinY() - dy), new Coordinate(datasetEnvelope.getMaxX() + dx, datasetEnvelope.getMinY() - dy), new Coordinate(datasetEnvelope.getMaxX() + dx, datasetEnvelope.getMaxY() + dy), new Coordinate(datasetEnvelope.getMinX() - dx, datasetEnvelope.getMaxY() + dy));
    }

    private void triangulate(List triangles, Coordinate newVertex) {
        Triangle triangleContainingNewVertex = this.triangleContaining(newVertex, triangles);
        Assert.isTrue((triangleContainingNewVertex != null ? 1 : 0) != 0);
        triangles.remove(triangleContainingNewVertex);
        ArrayList<Triangle> trianglesToAdd = new ArrayList<Triangle>();
        for (Triangle newTriangle : triangleContainingNewVertex.subTriangles(newVertex)) {
            Triangle adjacentTriangle = this.adjacentTriangle(newTriangle, triangles);
            if (adjacentTriangle == null) {
                trianglesToAdd.add(newTriangle);
                continue;
            }
            triangles.remove(adjacentTriangle);
            trianglesToAdd.addAll(this.heightMaximizedTriangles(newTriangle, adjacentTriangle));
        }
        triangles.addAll(trianglesToAdd);
    }

    private Triangle adjacentTriangle(Triangle triangle, List triangles) {
        for (Triangle candidate : triangles) {
            int vertexMatches = 0;
            if (candidate.hasVertex(triangle.getP1())) {
                ++vertexMatches;
            }
            if (candidate.hasVertex(triangle.getP2())) {
                ++vertexMatches;
            }
            if (candidate.hasVertex(triangle.getP3())) {
                ++vertexMatches;
            }
            Assert.isTrue((vertexMatches != 3 ? 1 : 0) != 0, (String)(String.valueOf(candidate) + "; " + String.valueOf(triangle)));
            if (vertexMatches != 2) continue;
            return candidate;
        }
        return null;
    }

    private Quadrilateral destQuad(Quadrilateral sourceQuad, List vectors) {
        if (vectors.isEmpty()) {
            return (Quadrilateral)sourceQuad.clone();
        }
        return new Quadrilateral(this.addVectorWithNearestTail(sourceQuad.getP1(), vectors), this.addVectorWithNearestTail(sourceQuad.getP2(), vectors), this.addVectorWithNearestTail(sourceQuad.getP3(), vectors), this.addVectorWithNearestTail(sourceQuad.getP4(), vectors));
    }

    private Coordinate addVectorWithNearestTail(Coordinate x, List vectors) {
        return this.add(x, this.vectorWithNearestTail(x, vectors));
    }

    private List triangulate(Quadrilateral quad, List vertices, TaskMonitor monitor) {
        monitor.allowCancellationRequests();
        monitor.report("Triangulating...");
        List triangles = quad.triangles();
        int count = 0;
        Iterator i = vertices.iterator();
        while (i.hasNext() && !monitor.isCancelRequested()) {
            Coordinate vertex = (Coordinate)i.next();
            this.triangulate(triangles, vertex);
            monitor.report(++count, vertices.size(), "vectors");
        }
        return triangles;
    }

    public static List taggedVectorVertices(boolean tips, Collection vectors) {
        ArrayList<TaggedCoordinate> taggedVectorVertices = new ArrayList<TaggedCoordinate>();
        for (LineString vector : vectors) {
            taggedVectorVertices.add(new TaggedCoordinate(tips ? vector.getCoordinateN(1) : vector.getCoordinateN(0), tips ? vector.getCoordinateN(0) : vector.getCoordinateN(1)));
        }
        return taggedVectorVertices;
    }

    private Map triangleMap(List taggedSourceTriangles) {
        HashMap<Triangle, Triangle> triangleMap = new HashMap<Triangle, Triangle>();
        for (Triangle sourceTriangle : taggedSourceTriangles) {
            triangleMap.put(sourceTriangle, new Triangle(((TaggedCoordinate)sourceTriangle.getP1()).getTag(), ((TaggedCoordinate)sourceTriangle.getP2()).getTag(), ((TaggedCoordinate)sourceTriangle.getP3()).getTag()));
        }
        return triangleMap;
    }

    private LineString toVector(TaggedCoordinate c, boolean tips) {
        return this.factory.createLineString(new Coordinate[]{tips ? c.getTag() : c, tips ? c : c.getTag()});
    }

    private Quadrilateral dissolve(Triangle PQS, Triangle QRS) {
        CollectionMap<Coordinate, Coordinate> vertexListMap = new CollectionMap<Coordinate, Coordinate>(TreeMap.class);
        vertexListMap.addItem(PQS.getP1(), PQS.getP1());
        vertexListMap.addItem(PQS.getP2(), PQS.getP2());
        vertexListMap.addItem(PQS.getP3(), PQS.getP3());
        vertexListMap.addItem(QRS.getP1(), QRS.getP1());
        vertexListMap.addItem(QRS.getP2(), QRS.getP2());
        vertexListMap.addItem(QRS.getP3(), QRS.getP3());
        ArrayList<Coordinate> sharedVertices = new ArrayList<Coordinate>();
        ArrayList<Coordinate> unsharedVertices = new ArrayList<Coordinate>();
        for (Coordinate vertex : vertexListMap.keySet()) {
            if (vertexListMap.getItems(vertex).size() == 1) {
                unsharedVertices.add(vertex);
                continue;
            }
            if (vertexListMap.getItems(vertex).size() == 2) {
                sharedVertices.add(vertex);
                continue;
            }
            Assert.shouldNeverReachHere();
        }
        Assert.isTrue((2 == sharedVertices.size() ? 1 : 0) != 0, (String)(String.valueOf(PQS) + "; " + String.valueOf(QRS)));
        Assert.isTrue((2 == unsharedVertices.size() ? 1 : 0) != 0, (String)(String.valueOf(PQS) + "; " + String.valueOf(QRS)));
        return new Quadrilateral((Coordinate)unsharedVertices.get(0), (Coordinate)sharedVertices.get(0), (Coordinate)unsharedVertices.get(1), (Coordinate)sharedVertices.get(1));
    }

    private TreeSet toVectors(Collection taggedVectorVertices, boolean tips) {
        TreeSet<LineString> badVectors = new TreeSet<LineString>();
        for (TaggedCoordinate c : taggedVectorVertices) {
            badVectors.add(this.toVector(c, tips));
        }
        return badVectors;
    }
}

