/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.warp;

import com.vividsolutions.jump.warp.Triangle;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class Quadrilateral
implements Cloneable {
    private final Coordinate p1;
    private final Coordinate p2;
    private final Coordinate p3;
    private final Coordinate p4;
    private final GeometryFactory factory = new GeometryFactory();

    public Envelope getEnvelope() {
        Envelope envelope = new Envelope(this.p1);
        envelope.expandToInclude(this.p2);
        envelope.expandToInclude(this.p3);
        envelope.expandToInclude(this.p4);
        return envelope;
    }

    protected Object clone() {
        return new Quadrilateral(new Coordinate(this.p1), new Coordinate(this.p2), new Coordinate(this.p3), new Coordinate(this.p4));
    }

    public Quadrilateral(Coordinate p1, Coordinate p2, Coordinate p3, Coordinate p4) {
        this.p1 = p1;
        this.p2 = p2;
        this.p3 = p3;
        this.p4 = p4;
    }

    private boolean diagonalsIntersect() {
        return Line2D.linesIntersect(this.p1.x, this.p1.y, this.p3.x, this.p3.y, this.p2.x, this.p2.y, this.p4.x, this.p4.y);
    }

    public boolean isConvex() {
        return this.diagonalsIntersect();
    }

    public List triangles() {
        ArrayList<Triangle> triangles = new ArrayList<Triangle>();
        triangles.add(new Triangle(this.p1, this.p2, this.p3));
        triangles.add(new Triangle(this.p1, this.p4, this.p3));
        return triangles;
    }

    private String toString(Coordinate c) {
        return c.x + " " + c.y;
    }

    public String toString() {
        return "LINESTRING (" + this.toString(this.p1) + ", " + this.toString(this.p2) + ", " + this.toString(this.p3) + ", " + this.toString(this.p4) + ", " + this.toString(this.p1) + ")";
    }

    public Coordinate getP1() {
        return this.p1;
    }

    public Coordinate getP2() {
        return this.p2;
    }

    public Coordinate getP3() {
        return this.p3;
    }

    public Coordinate getP4() {
        return this.p4;
    }

    public Polygon toPolygon() {
        return this.factory.createPolygon(this.factory.createLinearRing(new Coordinate[]{this.p1, this.p2, this.p3, this.p4, this.p1}), null);
    }

    public Collection verticesOutside(Collection vertices) {
        ArrayList<Coordinate> outsideVertices = new ArrayList<Coordinate>();
        Polygon quadrilateralPolygon = this.toPolygon();
        for (Coordinate vertex : vertices) {
            Point p = this.factory.createPoint(vertex);
            if (quadrilateralPolygon.contains((Geometry)p)) continue;
            outsideVertices.add(vertex);
        }
        return outsideVertices;
    }
}

