/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.warp;

import de.riwagis.geotools.feature.util.FeatureUtil;
import java.util.ArrayList;
import org.geotools.data.DataUtilities;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public abstract class CoordinateTransform {
    private final CoordinateFilter coordinateFilter = new CoordinateFilter(){

        public void filter(Coordinate coordinate) {
            coordinate.setCoordinate(CoordinateTransform.this.transform(coordinate));
        }
    };

    public abstract Coordinate transform(Coordinate var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FeatureCollection<SimpleFeatureType, SimpleFeature> transform(FeatureCollection<SimpleFeatureType, SimpleFeature> featureCollection) {
        ArrayList<SimpleFeature> lstNewFeatures = new ArrayList<SimpleFeature>();
        try (FeatureIterator i = featureCollection.features();){
            while (i.hasNext()) {
                SimpleFeature feature = (SimpleFeature)i.next();
                Geometry newGeometry = this.transform((Geometry)feature.getDefaultGeometry());
                SimpleFeature newFeature = FeatureUtil.cloneFeature((SimpleFeature)feature);
                newFeature.setDefaultGeometry((Object)newGeometry);
                lstNewFeatures.add(newFeature);
            }
        }
        return DataUtilities.collection(lstNewFeatures);
    }

    public Geometry transform(Geometry oldGeometry) {
        Geometry newGeometry = (Geometry)oldGeometry.clone();
        newGeometry.apply(this.coordinateFilter);
        newGeometry.geometryChanged();
        return newGeometry;
    }
}

