/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.util.commandline;

import com.vividsolutions.jump.util.commandline.Option;
import com.vividsolutions.jump.util.commandline.OptionSpec;
import com.vividsolutions.jump.util.commandline.ParseException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CommandLine {
    private Map<String, OptionSpec> optSpecs = new LinkedHashMap<String, OptionSpec>();
    private List<OptionSpec> optVec = new ArrayList<OptionSpec>();
    private char optionChar;

    public CommandLine() {
        this('/');
    }

    public CommandLine(char optionCh) {
        this.optionChar = optionCh;
    }

    public void addOptionSpec(OptionSpec optSpec) {
        String name = optSpec.getName();
        this.optSpecs.put(name.toLowerCase(), optSpec);
        this.optVec.add(optSpec);
    }

    OptionSpec getOptionSpec(String name) {
        if (this.optSpecs.containsKey(name.toLowerCase())) {
            return this.optSpecs.get(name.toLowerCase());
        }
        return null;
    }

    public Option getOption(String name) {
        OptionSpec spec = this.getOptionSpec(name);
        if (spec == null) {
            return null;
        }
        return spec.getOption(0);
    }

    public Iterator<Option> getOptions(String name) {
        OptionSpec spec = this.getOptionSpec(name);
        return spec.getOptions();
    }

    public boolean hasOption(String name) {
        OptionSpec spec = this.getOptionSpec(name);
        if (spec == null) {
            return false;
        }
        return spec.hasOption();
    }

    void addOption(Option opt) {
        String name = opt.getName();
        this.optSpecs.get(name.toLowerCase()).addOption(opt);
    }

    public void printDoc(PrintStream out) {
        out.println("Options:");
        for (OptionSpec os : this.optVec) {
            Object name = this.optionChar + os.getName();
            if (os.getName().equals("**FREE_ARGS**")) {
                name = "(free)";
            }
            out.println("  " + (String)name + " " + os.getArgDesc() + " - " + os.getDocDesc());
        }
    }

    public void parse(String[] args) throws ParseException {
        ArrayList<String> params = new ArrayList<String>();
        for (int i = 0; i < args.length; i += params.size()) {
            int paramStart;
            String noOptMsg;
            String optName;
            if (args[i].charAt(0) == this.optionChar) {
                optName = args[i].substring(1);
                noOptMsg = "Invalid option: " + args[i];
                paramStart = i + 1;
            } else {
                optName = "**FREE_ARGS**";
                noOptMsg = "Invalid option: " + args[i];
                paramStart = i;
            }
            OptionSpec optSpec = this.getOptionSpec(optName);
            if (optSpec == null) {
                throw new ParseException(noOptMsg);
            }
            int expectedArgCount = optSpec.getAllowedArgs();
            this.parseParams(args, params, paramStart, expectedArgCount);
            Option opt = optSpec.parse(params.toArray(new String[params.size()]));
            this.addOption(opt);
            ++i;
        }
    }

    void parseParams(String[] args, List<String> params, int i, int expectedArgCount) {
        params.clear();
        int count = 0;
        int expected = expectedArgCount;
        if (expectedArgCount == -3) {
            expected = 1;
        }
        if (expectedArgCount == -1) {
            expected = 999999999;
        }
        if (expectedArgCount == -2) {
            expected = 999999999;
        }
        int currIdx = i;
        while (currIdx < args.length && count < expected && args[currIdx].charAt(0) != this.optionChar) {
            params.add(args[currIdx++]);
            ++count;
        }
    }
}

