/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jdom2.xpath.XPath;

public class XMLUtil {
    private static final SAXBuilder sb = new SAXBuilder();
    private static final XMLOutputter out = new XMLOutputter();

    XMLUtil() {
    }

    public static Document build(File file) throws Exception {
        return sb.build(file);
    }

    public static Document build(String filename) throws Exception {
        return sb.build(filename);
    }

    public static Document build(Reader xmlread) throws Exception {
        return sb.build(xmlread);
    }

    public static void output(Document doc, File file) throws Exception {
        BufferedOutputStream out1 = new BufferedOutputStream(new FileOutputStream(file));
        out.output(doc, (OutputStream)out1);
    }

    public static void output(Document doc, String filename) throws Exception {
        BufferedOutputStream out1 = new BufferedOutputStream(new FileOutputStream(filename));
        out.setFormat(Format.getPrettyFormat());
        out.output(doc, (OutputStream)out1);
    }

    public static Element getElement(Document xmlDoc, Namespace ns, String strXPath) throws Exception {
        XPath xpath = XPath.newInstance((String)strXPath);
        xpath.addNamespace(ns);
        List lst = xpath.selectNodes((Object)xmlDoc);
        if (lst.size() > 1) {
            throw new JDOMException(XMLUtil.class.getName() + " : more than one element found");
        }
        if (lst.size() == 0) {
            throw new JDOMException(XMLUtil.class.getName() + " : no element found");
        }
        return (Element)lst.get(0);
    }

    public static String getText(Document xmlDoc, Namespace ns, String strXPath) throws Exception {
        XPath xpath = XPath.newInstance((String)strXPath);
        xpath.addNamespace(ns);
        List lst = xpath.selectNodes((Object)xmlDoc);
        if (lst.size() > 1) {
            throw new JDOMException(XMLUtil.class.getName() + " : more than one element found");
        }
        if (lst.size() == 0) {
            throw new JDOMException(XMLUtil.class.getName() + " : no element found");
        }
        Element el = (Element)lst.get(0);
        return el.getTextTrim();
    }

    public static String getAttributeText(Document xmlDoc, Namespace ns, String strXPath, String attName) throws Exception {
        XPath xpath = XPath.newInstance((String)strXPath);
        xpath.addNamespace(ns);
        List lst = xpath.selectNodes((Object)xmlDoc);
        if (lst.size() > 1) {
            throw new JDOMException(XMLUtil.class.getName() + " : more than one element found");
        }
        if (lst.size() == 0) {
            throw new JDOMException(XMLUtil.class.getName() + " : no element found");
        }
        Element el = (Element)lst.get(0);
        return el.getAttributeValue(attName);
    }

    public static void setText(Document xmlDoc, Namespace ns, String strXPath, String strText) throws Exception {
        XPath xpath = XPath.newInstance((String)strXPath);
        xpath.addNamespace(ns);
        List lst = xpath.selectNodes((Object)xmlDoc);
        if (lst.size() > 1) {
            throw new JDOMException(XMLUtil.class.getName() + " : more than one element found");
        }
        if (lst.size() == 0) {
            throw new JDOMException(XMLUtil.class.getName() + " : no element found");
        }
        Element el = (Element)lst.get(0);
        el.setText(strText);
    }

    public static void setAttribute(Document xmlDoc, Namespace ns, String strXPath, String attName, String strAttText) throws Exception {
        XPath xpath = XPath.newInstance((String)strXPath);
        xpath.addNamespace(ns);
        List lst = xpath.selectNodes((Object)xmlDoc);
        if (lst.size() > 1) {
            throw new JDOMException(XMLUtil.class.getName() + " : more than one element found");
        }
        if (lst.size() == 0) {
            throw new JDOMException(XMLUtil.class.getName() + " : no element found");
        }
        Element el = (Element)lst.get(0);
        el.setAttribute(attName, strAttText);
    }

    public static void main(String[] args) {
        try {
            Document doc = XMLUtil.build("E:\\xml\\RGZparam.xml");
            Namespace ns = Namespace.getNamespace((String)"");
            System.out.println(doc.getBaseURI());
            System.out.println(XMLUtil.getText(doc, ns, "/Document/Userdata/dbuser"));
            System.out.println(XMLUtil.getAttributeText(doc, ns, "/Document/Userdata", "ref_id"));
            XMLUtil.setText(doc, ns, "/Document/Userdata/dbuser", "test123");
            XMLUtil.setAttribute(doc, ns, "/Document/Userdata", "ref_id", "123");
            XMLUtil.output(doc, "E:\\xml\\RGZparam_123.xml");
        }
        catch (Exception e) {
            System.out.println("Error in XMLSupport");
        }
    }
}

