/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.util;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.Comparator;
import java.util.TreeMap;
import org.locationtech.jts.util.Assert;

@XStreamAlias(value="range")
public class RangeDeleteInFuture {
    private boolean includingMin;
    private boolean includingMax;
    private Object max;
    private Object min;
    private static final Comparator INFINITY_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1 instanceof PositiveInfinity || o2 instanceof NegativeInfinity) {
                return 1;
            }
            if (o1 instanceof NegativeInfinity || o2 instanceof PositiveInfinity) {
                return -1;
            }
            return ((Comparable)o1).compareTo(o2);
        }
    };
    public static final Comparator RANGE_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            RangeDeleteInFuture range1 = o1 instanceof RangeDeleteInFuture ? (RangeDeleteInFuture)o1 : new RangeDeleteInFuture(o1, true, o1, true);
            RangeDeleteInFuture range2 = o2 instanceof RangeDeleteInFuture ? (RangeDeleteInFuture)o2 : new RangeDeleteInFuture(o2, true, o2, true);
            int max1ComparedToMin2 = INFINITY_COMPARATOR.compare(range1.getMax(), range2.getMin());
            if (max1ComparedToMin2 < 0 || max1ComparedToMin2 == 0 && (!range1.isIncludingMax() || !range2.isIncludingMin())) {
                return -1;
            }
            int min1ComparedToMax2 = INFINITY_COMPARATOR.compare(range1.getMin(), range2.getMax());
            if (min1ComparedToMax2 > 0 || min1ComparedToMax2 == 0 && (!range1.isIncludingMin() || !range2.isIncludingMax())) {
                return 1;
            }
            return 0;
        }
    };

    public String toString() {
        return String.valueOf(this.min) + " - " + String.valueOf(this.max);
    }

    public RangeDeleteInFuture() {
        this(new NegativeInfinity(), false, new PositiveInfinity(), false);
    }

    public RangeDeleteInFuture(Object min, boolean includingMin, Object max, boolean includingMax) {
        Assert.isTrue((!min.equals(max) || includingMin && includingMax ? 1 : 0) != 0);
        this.min = min;
        this.max = max;
        this.includingMin = includingMin;
        this.includingMax = includingMax;
    }

    public boolean equals(Object obj) {
        return RANGE_COMPARATOR.compare(this, obj) == 0;
    }

    public boolean isIncludingMax() {
        return this.includingMax;
    }

    public boolean isIncludingMin() {
        return this.includingMin;
    }

    public Object getMax() {
        return this.max;
    }

    public Object getMin() {
        return this.min;
    }

    public void setIncludingMax(boolean b) {
        this.includingMax = b;
    }

    public void setIncludingMin(boolean b) {
        this.includingMin = b;
    }

    public void setMax(Object object) {
        this.max = object;
    }

    public void setMin(Object object) {
        this.min = object;
    }

    @XStreamAlias(value="rangeNegativeInfinity")
    public static final class NegativeInfinity {
        public String toString() {
            return "";
        }
    }

    @XStreamAlias(value="rangePositiveInfinity")
    public static final class PositiveInfinity {
        public String toString() {
            return "";
        }
    }

    public static class RangeTreeMap<K, V>
    extends TreeMap<K, V> {
        public RangeTreeMap() {
            super(RANGE_COMPARATOR);
        }
    }
}

