/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.util;

import de.riwagis.service.directory.DirectoryService;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;

public class PropertiesHandler {
    protected String propertiesFile = null;
    protected Properties properties = null;
    public static final String propertiesFileEnding = ".properties";

    public PropertiesHandler(String propertiesFileName) {
        this.propertiesFile = DirectoryService.getInstance().getApplicationDataDirectory().getAbsolutePath() + File.separator + propertiesFileName;
        this.properties = new Properties();
    }

    public boolean contains(Object value) {
        return this.properties.contains(value);
    }

    public boolean containsKey(Object key) {
        return this.properties.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.properties.containsValue(value);
    }

    public Enumeration elements() {
        return this.properties.elements();
    }

    public String getProperty(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public Enumeration keys() {
        return this.properties.keys();
    }

    public Set keySet() {
        return this.properties.keySet();
    }

    public void load() throws IOException {
        if (!this.properties.isEmpty()) {
            this.properties.clear();
        }
        FileInputStream fis = new FileInputStream(this.propertiesFile);
        this.properties.load(fis);
        fis.close();
    }

    public void putAll(Map<String, String> arg0) {
        this.properties.putAll(arg0);
    }

    public Object remove(Object arg0) {
        return this.properties.remove(arg0);
    }

    public Object setProperty(String key, String value) {
        if (this.properties.containsKey(key)) {
            this.properties.remove(key);
        }
        return this.properties.setProperty(key, value);
    }

    public Object setProperty(String key, Color value) {
        if (this.properties.containsKey(key)) {
            this.properties.remove(key);
        }
        return this.properties.setProperty(key, Integer.toString(value.getRGB()));
    }

    public void store(String comments) throws IOException {
        File propFile = new File(this.propertiesFile);
        String pathString = this.propertiesFile.indexOf(File.separator) > -1 ? this.propertiesFile.substring(0, this.propertiesFile.lastIndexOf(File.separator)) : "";
        File propFilePath = new File(pathString);
        if (!propFile.exists()) {
            try {
                propFilePath.mkdirs();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        FileOutputStream fos = new FileOutputStream(propFile);
        this.properties.store(fos, comments);
        fos.close();
    }

    public void store() throws IOException {
        this.store(null);
    }

    public int getPropertyAsInt(String key) {
        if (this.properties.containsKey(key)) {
            return Integer.parseInt(this.properties.get(key).toString());
        }
        throw new NoSuchElementException("key: \"" + key + "\"");
    }

    public int getPropertyAsInt(String key, int defaultValue) {
        if (this.properties.containsKey(key)) {
            return this.getPropertyAsInt(key);
        }
        this.properties.setProperty(key, new Integer(defaultValue).toString());
        return defaultValue;
    }

    public boolean getPropertyAsBoolean(String key) {
        if (this.properties.containsKey(key)) {
            return Boolean.valueOf(this.properties.get(key).toString());
        }
        throw new NoSuchElementException("key: \"" + key + "\"");
    }

    public boolean getPropertyAsBoolean(String key, boolean defaultValue) {
        if (this.properties.containsKey(key)) {
            return this.getPropertyAsBoolean(key);
        }
        this.properties.setProperty(key, new Boolean(defaultValue).toString());
        return defaultValue;
    }

    public double getPropertyAsDouble(String key) {
        if (this.properties.containsKey(key)) {
            return Double.parseDouble(this.properties.get(key).toString());
        }
        throw new NoSuchElementException("key: \"" + key + "\"");
    }

    public double getPropertyAsDouble(String key, double defaultValue) {
        if (this.properties.containsKey(key)) {
            return this.getPropertyAsDouble(key);
        }
        this.properties.setProperty(key, new Double(defaultValue).toString());
        return defaultValue;
    }

    public Color getPropertyAsColor(String key) {
        if (this.properties.containsKey(key)) {
            return Color.decode(this.properties.get(key).toString());
        }
        throw new NoSuchElementException("key: \"" + key + "\"");
    }

    public Color getPropertyAsColor(String key, Color defaultValue) {
        if (this.properties.containsKey(key)) {
            return this.getPropertyAsColor(key);
        }
        this.setProperty(key, defaultValue);
        return defaultValue;
    }

    public String getPropertiesFile() {
        return this.propertiesFile;
    }
}

