/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.util;

import com.vividsolutions.jump.workbench.ui.GUIUtil;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class HtmlBuilder {
    private final StringBuilder builder;

    public HtmlBuilder(String initialContent) {
        this.builder = new StringBuilder(initialContent);
    }

    public HtmlBuilder() {
        this.builder = new StringBuilder();
    }

    public String build() {
        String content = this.builder.toString();
        if (StringUtils.containsIgnoreCase((CharSequence)content, (CharSequence)"<html")) {
            return content;
        }
        this.builder.insert(0, "<html>");
        this.builder.append("</html>");
        return this.builder.toString();
    }

    public HtmlBuilder addField(String label, String value) {
        return this.addField(label, value, "");
    }

    public HtmlBuilder append(String html) {
        this.builder.append(html);
        return this;
    }

    public HtmlBuilder addText(String text) {
        return this.append(GUIUtil.escapeHTML(text, false, true) + " <BR>\n");
    }

    public HtmlBuilder addField(String label, String value, String units) {
        return this.append(String.format("<B> %s </B>%s %s <BR>%n", label, value, units));
    }

    public HtmlBuilder addBlockElement(String blockElementTag, Map<String, String> extraAttributes, String text) {
        StringBuilder b = new StringBuilder();
        if (!extraAttributes.isEmpty()) {
            for (Map.Entry<String, String> currElement : extraAttributes.entrySet()) {
                b.append(" ");
                if (currElement.getValue() == null) {
                    b.append(currElement.getKey());
                    continue;
                }
                b.append(currElement.getKey()).append("=\"").append(currElement.getValue()).append("\"");
            }
        }
        String format = String.format("<%1$s%2$s>%3$s</%1$s>%n", blockElementTag, b, text);
        return this.append(format);
    }

    public HtmlBuilder addHeader(int level, String text) {
        return this.addBlockElement("h" + level, Collections.emptyMap(), GUIUtil.escapeHTML(text, false, false));
    }
}

