/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.util;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;

public class FileUtil {
    public static final Charset FILEUTIL_CHARSET = Charsets.ISO_8859_1;

    public static List<String> getContents(String textFileName) throws FileNotFoundException, IOException {
        return FileUtil.getContents(new FileInputStream(textFileName));
    }

    public static List<String> getContents(Reader rd) throws IOException {
        String line;
        ArrayList<String> contents = new ArrayList<String>();
        BufferedReader bufferedReader = new BufferedReader(rd);
        while ((line = bufferedReader.readLine()) != null) {
            contents.add(line);
        }
        return contents;
    }

    public static List<String> getContents(InputStream inputStream) throws IOException {
        return FileUtil.getContents(new InputStreamReader(inputStream, FILEUTIL_CHARSET));
    }

    public static void setContents(String textFileName, String contents) throws IOException {
        try (OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(textFileName, false), FILEUTIL_CHARSET);){
            FileUtil.setContents(fileWriter, contents);
        }
    }

    public static void setContents(Writer writer, String contents) throws IOException {
        try {
            writer.write(contents);
        }
        finally {
            writer.flush();
        }
    }

    public static void setContents(String textFileName, List<String> lines) throws IOException {
        StringBuilder contents = new StringBuilder();
        for (String currentLine : lines) {
            String lineSepa = System.getProperty("line.separator");
            contents.append(currentLine).append(lineSepa);
        }
        FileUtil.setContents(textFileName, contents.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(Collection<File> files, File zipFile) throws IOException {
        try (ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)));){
            for (File currentFile : files) {
                zos.putNextEntry(new ZipEntry(currentFile.getName()));
                try (FileInputStream fis = new FileInputStream(currentFile);){
                    IOUtils.copyLarge((InputStream)fis, (OutputStream)zos);
                }
                finally {
                    zos.closeEntry();
                }
            }
        }
    }

    public static String getExtension(File f) {
        String s;
        int i;
        String ext = "";
        if (f != null && (i = (s = f.getName()).lastIndexOf(46)) > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static File addExtensionIfNone(File file, String extension) {
        if (FileUtil.getExtension(file).length() > 0 || extension == null || extension.length() == 0) {
            return file;
        }
        Object path = file.getPath();
        if (!((String)path).endsWith(".")) {
            path = (String)path + ".";
        }
        path = (String)path + extension;
        return new File((String)path);
    }

    private FileUtil() {
    }
}

