/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.util;

import com.vividsolutions.jump.I18N;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import org.dhatim.fastexcel.StyleSetter;
import org.dhatim.fastexcel.Workbook;
import org.dhatim.fastexcel.Worksheet;
import org.dhatim.fastexcel.reader.Cell;
import org.dhatim.fastexcel.reader.ReadableWorkbook;
import org.dhatim.fastexcel.reader.Sheet;
import org.geotools.geometry.jts.WKTWriter2;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;

public class ExcelExport {
    public static final String FILE_EXTENSION = "xlsx";
    private static final String FORMAT_DATE = "dd.MM.yyyy";
    private static final String FORMAT_TIMESTAMP = "dd.MM.yyyy H:mm:ss";

    public static boolean writeFile(Map<String, TableAttributes> tableAttributes, File file) throws IOException {
        if (tableAttributes == null || file == null) {
            return false;
        }
        try (OutputStream os = Files.newOutputStream(file.toPath(), new OpenOption[0]);
             Workbook wb = ExcelExport.createWorkbook(os);){
            tableAttributes.forEach((layerName, tableAttribute) -> {
                JTable table = tableAttribute.table();
                if (table == null) {
                    throw new IllegalArgumentException("Table must not be NULL.");
                }
                Set<Integer> ignoredColumns = tableAttribute.ignoredColumns();
                Worksheet ws = ExcelExport.createWorksheet(wb, layerName, table.getColumnCount(), ignoredColumns.size());
                Enumeration<TableColumn> columns = table.getTableHeader().getColumnModel().getColumns();
                int checkIndex = 0;
                int columnIndex = 0;
                while (columns.hasMoreElements()) {
                    String columnName = columns.nextElement().getHeaderValue().toString();
                    if (ignoredColumns != null && ignoredColumns.contains(checkIndex)) {
                        ++checkIndex;
                        continue;
                    }
                    ExcelExport.writeHeader(ws, 0, columnIndex, columnName);
                    ++columnIndex;
                }
                for (int row = 0; row < table.getRowCount(); ++row) {
                    ExcelExport.writeValues2Cells(ws, row, table, ignoredColumns);
                }
            });
        }
        return true;
    }

    public static boolean writeFile(String sheetName, List<SimpleFeature> features, File file) throws IOException {
        if (features == null || features.isEmpty() || file == null) {
            return false;
        }
        try (OutputStream os = Files.newOutputStream(file.toPath(), new OpenOption[0]);
             Workbook wb = ExcelExport.createWorkbook(os);){
            String name = sheetName == null || sheetName.isBlank() ? I18N.getMessage("sheet-x", 1) : sheetName;
            Worksheet ws = ExcelExport.createWorksheet(wb, name, features.get(0).getAttributeCount(), 0);
            for (int row = 0; row < features.size(); ++row) {
                SimpleFeature feature = features.get(row);
                List attributeList = feature.getAttributes();
                for (int column = 0; column < attributeList.size(); ++column) {
                    String columnName = feature.getFeatureType().getDescriptor(column).getName().getLocalPart();
                    Object attribute = attributeList.get(column);
                    if (row == 0) {
                        ExcelExport.writeHeader(ws, row, column, columnName);
                    }
                    ExcelExport.writeValue2Cell(ws, row, column, attribute);
                }
            }
        }
        return true;
    }

    private static Workbook createWorkbook(OutputStream os) throws IOException {
        Workbook wb = new Workbook(os, "GIS-Client", "1.0");
        wb.properties().setCompany("RIWA GmbH");
        return wb;
    }

    private static Worksheet createWorksheet(Workbook wb, String sheetName, int columnCount, int ignoredColumnSize) {
        Worksheet ws = wb.newWorksheet(sheetName);
        ((StyleSetter)((StyleSetter)ws.range(0, 0, 0, columnCount - ignoredColumnSize - 1).style().bold()).fillColor("EEEEEE")).set();
        return ws;
    }

    private static void writeHeader(Worksheet ws, int row, int column, String columnName) {
        ws.width(column, 25.0);
        ws.value(row, column, columnName);
    }

    private static void writeValues2Cells(Worksheet ws, int row, JTable table, Set<Integer> ignoredColumns) {
        int columnIndex = 0;
        for (int column = 0; column < table.getColumnCount(); ++column) {
            if (ignoredColumns != null && ignoredColumns.contains(column)) continue;
            ExcelExport.writeValue2Cell(ws, row, columnIndex, table.getValueAt(row, column));
            ++columnIndex;
        }
    }

    private static void writeValue2Cell(Worksheet ws, int row, int column, Object cellValue) {
        if (cellValue != null) {
            int realRow = row + 1;
            if (cellValue instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)cellValue;
                ((StyleSetter)ws.style(realRow, column).format(FORMAT_TIMESTAMP)).set();
                ws.value(realRow, column, (Date)timestamp);
            } else if (cellValue instanceof Date) {
                Date date = (Date)cellValue;
                ((StyleSetter)ws.style(realRow, column).format(FORMAT_DATE)).set();
                ws.value(realRow, column, date);
            } else if (cellValue instanceof Number) {
                Number number = (Number)cellValue;
                ws.value(realRow, column, number);
            } else if (cellValue instanceof Geometry) {
                Geometry geom = (Geometry)cellValue;
                WKTWriter2 wktWriter = new WKTWriter2();
                ws.value(realRow, column, wktWriter.write(geom));
            } else {
                ws.value(realRow, column, cellValue.toString());
            }
        }
    }

    public static Map<String, Map<Integer, List<String>>> readFile(String fileLocation) throws IOException {
        HashMap<String, Map<Integer, List<String>>> data = new HashMap<String, Map<Integer, List<String>>>();
        try (FileInputStream file = new FileInputStream(fileLocation);
             ReadableWorkbook wb = new ReadableWorkbook((InputStream)file);){
            for (Sheet sheet : wb.getSheets().toList()) {
                data.put(sheet.getName(), new HashMap());
                Stream rows = sheet.openStream();
                try {
                    rows.forEach(cells -> {
                        Map rowsMap = (Map)data.get(sheet.getName());
                        rowsMap.put(cells.getRowNum(), new ArrayList());
                        for (Cell cell : cells) {
                            ((List)rowsMap.get(cells.getRowNum())).add(cell.getRawValue());
                        }
                    });
                }
                finally {
                    if (rows == null) continue;
                    rows.close();
                }
            }
        }
        return data;
    }

    public record TableAttributes(JTable table, Set<Integer> ignoredColumns) {
        public TableAttributes {
            Objects.requireNonNull(table);
            Objects.requireNonNull(ignoredColumns);
        }
    }
}

