/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import org.locationtech.jts.util.Assert;

public class CollectionUtil {
    private CollectionUtil() {
    }

    public static <M> Collection<M> concatenate(Collection<Collection<M>> collections) {
        ArrayList<M> concatenation = new ArrayList<M>();
        for (Collection<M> collection : collections) {
            concatenation.addAll(collection);
        }
        return concatenation;
    }

    public static Set<Integer> reverseSortedSet(int[] ints) {
        TreeSet<Integer> sortedSet = new TreeSet<Integer>(Collections.reverseOrder());
        for (int anInt : ints) {
            sortedSet.add(anInt);
        }
        return sortedSet;
    }

    public static <M> List<M> reverse(List<M> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        ArrayList<M> newList = new ArrayList<M>(list);
        Collections.reverse(newList);
        return newList;
    }

    public static <T> Collection<T> stretch(Collection<T> source, Collection<T> destination, int destinationSize) {
        Assert.isTrue((boolean)destination.isEmpty());
        List<Object> originalList = source instanceof List ? (List<Object>)source : new ArrayList<T>(source);
        for (int i = 0; i < destinationSize; ++i) {
            destination.add(originalList.get((int)Math.round((double)(i * originalList.size()) / (double)destinationSize)));
        }
        return destination;
    }

    public static <T> void setIfNull(int i, List<T> list, T value) {
        if (i >= list.size()) {
            CollectionUtil.resize(list, i + 1);
        }
        if (list.get(i) != null) {
            return;
        }
        list.set(i, value);
    }

    public static <T> void resize(List<T> list, int newSize) {
        if (newSize < list.size()) {
            list.subList(newSize, list.size()).clear();
        } else {
            list.addAll(Collections.nCopies(newSize - list.size(), null));
        }
    }

    public static <T> void addIfNotNull(T item, Collection<T> collection) {
        if (item != null) {
            collection.add(item);
        }
    }

    public static <T, R> Collection<R> collect(Collection<T> collection, Function<T, R> block) {
        ArrayList<R> result = new ArrayList<R>();
        for (T item : collection) {
            result.add(block.apply(item));
        }
        return result;
    }

    public static <T> Collection<T> select(Collection<T> collection, Predicate<T> block) {
        ArrayList<T> result = new ArrayList<T>();
        for (T item : collection) {
            if (!Boolean.TRUE.equals(block.test(item))) continue;
            result.add(item);
        }
        return result;
    }

    public static <T> Object get(Class<?> c, Map<Class<?>, T> map) {
        if (map.containsKey(c)) {
            return map.get(c);
        }
        for (Map.Entry<Class<?>, T> candidateClass : map.entrySet()) {
            if (!candidateClass.getKey().isAssignableFrom(c)) continue;
            return candidateClass.getValue();
        }
        return null;
    }
}

