/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.locationtech.jts.util.Assert;

public class CollectionMap<K, V>
implements Map<K, Collection<V>> {
    private final Map<K, Collection<V>> map;
    private final Class<? extends Collection> collectionClass;

    public CollectionMap(Class<? extends Map> mapClass) {
        this(mapClass, ArrayList.class);
    }

    public CollectionMap(Class<? extends Map> mapClass, Class<? extends Collection> collectionClass) {
        this.collectionClass = collectionClass;
        try {
            this.map = mapClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Illegal Map-Class: " + String.valueOf(mapClass), e);
        }
    }

    public CollectionMap() {
        this(HashMap.class);
    }

    private Collection<V> getItemsInternal(K key) {
        Collection collection = this.map.get(key);
        if (collection == null) {
            try {
                Collection newCollection;
                collection = newCollection = this.collectionClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                Assert.shouldNeverReachHere((String)e.getMessage());
            }
            this.map.put(key, collection);
        }
        return collection;
    }

    public void addItem(K key, V item) {
        this.getItemsInternal(key).add(item);
    }

    public void removeItem(K key, V item) {
        this.getItemsInternal(key).remove(item);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public void addItems(K key, Collection<V> items) {
        Iterator<V> i = items.iterator();
        while (i.hasNext()) {
            this.addItem(key, i.next());
        }
    }

    public void addItems(CollectionMap<K, V> other) {
        for (Map.Entry<K, Collection<V>> currEntry : other.entrySet()) {
            this.addItems(currEntry.getKey(), currEntry.getValue());
        }
    }

    @Override
    public Collection<Collection<V>> values() {
        return this.map.values();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<V> get(Object key) {
        return this.getItems(key);
    }

    public Collection<V> getItems(Object key) {
        return Collections.unmodifiableCollection(this.getItemsInternal(key));
    }

    @Override
    public Collection<V> remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, Collection<V>>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Collection<V> put(K key, Collection<V> value) {
        return this.map.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends Collection<V>> map) {
        for (Map.Entry<K, Collection<V>> currEntry : map.entrySet()) {
            this.put(currEntry.getKey(), currEntry.getValue());
        }
    }

    public void removeItems(K key, Collection<V> items) {
        this.getItemsInternal(key).removeAll(items);
    }

    public void removeAll(K key) {
        this.getItemsInternal(key).clear();
    }

    public Map<K, Collection<V>> getMap() {
        return this.map;
    }
}

