/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Blackboard
implements Cloneable,
Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(Blackboard.class);
    private static final long serialVersionUID = 6504993615735124204L;
    private final Map<String, Object> properties = new HashMap<String, Object>();

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties.clear();
        this.properties.putAll(properties);
    }

    public void remove(String key) {
        this.properties.remove(key);
    }

    public boolean contains(String key) {
        return this.properties.containsKey(key);
    }

    public Blackboard put(String key, Object value) {
        this.properties.put(key, value);
        return this;
    }

    public Object get(String key) {
        return this.properties.get(key);
    }

    public Blackboard put(String key, boolean value) {
        this.put(key, (Object)value);
        return this;
    }

    public Blackboard putAll(Map<String, Object> properties) {
        this.properties.putAll(properties);
        return this;
    }

    public boolean get(String key, boolean defaultValue) {
        if (this.get(key) == null) {
            this.put(key, defaultValue);
        }
        return this.getBoolean(key);
    }

    public Boolean getBoolean(String key) {
        return (Boolean)this.get(key);
    }

    public Blackboard put(String key, int value) {
        this.put(key, new Integer(value));
        return this;
    }

    public Blackboard put(String key, double value) {
        this.put(key, new Double(value));
        return this;
    }

    public double get(String key, double defaultValue) {
        if (this.get(key) == null) {
            this.put(key, defaultValue);
        }
        return this.getDouble(key);
    }

    public int get(String key, int defaultValue) {
        Integer aInt;
        if (this.get(key) == null) {
            this.put(key, defaultValue);
        }
        return (aInt = this.getInt(key)) == null ? defaultValue : aInt;
    }

    public String get(String key, String defaultValue) {
        if (this.get(key) == null) {
            this.put(key, defaultValue);
        }
        return this.getString(key);
    }

    public Integer getInt(String key) {
        try {
            return (Integer)this.get(key);
        }
        catch (ClassCastException cce) {
            LOG.error(String.format("unable to load key '%s' as INTEGER: %s", key, cce.getMessage()));
            return null;
        }
    }

    public double getDouble(String key) {
        return (Double)this.get(key);
    }

    public String getString(String key) {
        return (String)this.get(key);
    }

    public Object get(String key, Object defaultValue) {
        if (this.get(key) == null) {
            this.put(key, defaultValue);
        }
        return this.get(key);
    }

    public Object clone() throws CloneNotSupportedException {
        Blackboard tmpBB = (Blackboard)super.clone();
        return tmpBB.putAll(this.properties);
    }
}

