/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.task;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.CompactWriter;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.ui.plugin.io.project.XStreamUtilTask;
import de.riwagis.riwajump.model.version.AbstractVersionConverter;
import de.riwagis.riwajump.model.version.VersionConverter;
import de.riwagis.riwajump.model.version.VersionDependentAdjuster;
import de.riwagis.service.directory.DirectoryService;
import de.riwagis.service.directory.ProjectType;
import de.riwagis.util.jdom.JDOMUtils;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.locationtech.jts.util.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskUtil {
    private static final Logger LOG = LoggerFactory.getLogger(TaskUtil.class);
    private static final XStream xstream = XStreamUtilTask.getTaskXStream();

    public static final Task loadTask(File file) throws IOException, JDOMException {
        HashSet<File> filesToDelete = new HashSet<File>();
        try {
            Task task;
            LOG.info("Loading file: '{}'", (Object)file);
            boolean errorOnRetrievingTask = false;
            boolean errorOnConvert = false;
            try {
                task = TaskUtil.fetchTaskAndAdjustIfNecessary(file, filesToDelete, VersionDependentAdjuster.AdjusterType.BEFORE_DESERIALIZATION);
                if (task.getProjectVersion() < 22) {
                    LOG.info("Task '{}' retrieved is of wrong version ({}) and needs to be adjusted (correct version: {})", new Object[]{file, task.getProjectVersion(), 22});
                    task = null;
                    errorOnRetrievingTask = true;
                }
            }
            catch (Exception e) {
                LOG.warn("unable to perform task adjustments on '{}': {}", new Object[]{file, e.getMessage(), e});
                task = null;
                errorOnRetrievingTask = true;
            }
            if (errorOnRetrievingTask) {
                try {
                    task = TaskUtil.fetchConvertedTask(file, filesToDelete);
                }
                catch (Exception e) {
                    errorOnConvert = true;
                }
            }
            if (errorOnConvert) {
                task = TaskUtil.fetchTaskAndAdjustIfNecessary(file, filesToDelete, VersionDependentAdjuster.AdjusterType.ON_CRASH);
            }
            if (task != null) {
                task.resetVersion();
                task.setProjectFile(file);
                TaskUtil.relinkTask(task);
            }
            Task task2 = task;
            return task2;
        }
        catch (IOException | JDOMException e) {
            LOG.error("Task '{}' could not be imported: {}", (Object)file, (Object)e.getMessage());
            throw e;
        }
        finally {
            for (File fileToDelete : filesToDelete) {
                FileUtils.deleteQuietly((File)fileToDelete);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private static Task fetchConvertedTask(File file, Set<File> filesToDelete) throws IOException, JDOMException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Loose catch block
     */
    private static Task fetchTaskAndAdjustIfNecessary(File file, Set<File> filesToDelete, VersionDependentAdjuster.AdjusterType adjusterType) throws IOException, JDOMException {
        LOG.info("Attempting to perform bugfix in-between releases: '{}'", (Object)file);
        try (FileInputStream fin = new FileInputStream(file);
             ZipInputStream zin = new ZipInputStream(fin);){
            zin.getNextEntry();
            try (InputStreamReader bread = new InputStreamReader((InputStream)zin, StandardCharsets.UTF_8);){
                Document doc = JDOMUtils.build((Reader)bread);
                boolean fixApplied = adjusterType.adjustIfNecessary(doc, 22);
                if (fixApplied) {
                    Task task;
                    LOG.info("In-between bugfix was necessary: '{}'", (Object)file);
                    File tempFileForFix = TaskUtil.createTempFileFromDoc(doc, "adjusted", filesToDelete);
                    try (BufferedReader fixedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(tempFileForFix), StandardCharsets.UTF_8));){
                        task = (Task)xstream.fromXML((Reader)fixedReader);
                    }
                    return task;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
    }

    private static File createTempFileFromDoc(Document doc, String prefix, Set<File> filesToDelete) throws IOException {
        File tempDir = DirectoryService.getInstance().getProjectTempDirectory(ProjectType.JUMP);
        Files.createDirectories(tempDir.toPath(), new FileAttribute[0]);
        File targetFile = new File(tempDir, prefix + "_project.xml");
        filesToDelete.add(targetFile);
        JDOMUtils.output((Document)doc, (File)targetFile);
        return targetFile;
    }

    public static final void saveTask(Task task, File file) throws IOException, JDOMException {
        TaskUtil.saveTask(task, file, 22);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void saveTask(Task task, File file, int version) throws IOException, JDOMException {
        block29: {
            task.resetVersion();
            task.getLayerManager().cleanUp();
            task.updateBasePath(file);
            try (FileOutputStream fout = new FileOutputStream(file);
                 ZipOutputStream zipout = new ZipOutputStream(fout);){
                if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.APP_SUDDEN_TERMINATION)) {
                    Desktop.getDesktop().disableSuddenTermination();
                }
                zipout.setLevel(9);
                ZipEntry zEntry = new ZipEntry("project.xml");
                zipout.putNextEntry(zEntry);
                if (22 == version) {
                    try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)zipout, StandardCharsets.UTF_8));){
                        xstream.marshal((Object)task, (HierarchicalStreamWriter)new CompactWriter((Writer)bufferedWriter));
                        ((Writer)bufferedWriter).flush();
                        break block29;
                    }
                }
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                OutputStreamWriter tmpwriter = new OutputStreamWriter((OutputStream)bout, StandardCharsets.UTF_8);
                xstream.marshal((Object)task, (HierarchicalStreamWriter)new CompactWriter((Writer)tmpwriter));
                ((Writer)tmpwriter).flush();
                ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
                InputStreamReader tmpreader = new InputStreamReader((InputStream)bin, StandardCharsets.UTF_8);
                Document doc = JDOMUtils.build((Reader)tmpreader);
                for (int i = VersionConverter.CONVERTERS.length - 1; i >= 0 && VersionConverter.CONVERTERS[i].oldVersionNumber() >= version; --i) {
                    if (!VersionConverter.CONVERTERS[i].supportsUnconvert()) {
                        Assert.shouldNeverReachHere((String)"Selected version can not be saved.");
                    }
                    VersionConverter.CONVERTERS[i].unconvert(doc);
                }
                AbstractVersionConverter.setProjectVersion((Document)doc, (int)version);
                try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)zipout, StandardCharsets.UTF_8));){
                    JDOMUtils.output((Document)doc, (Writer)bufferedWriter);
                    ((Writer)bufferedWriter).flush();
                }
            }
            finally {
                if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.APP_SUDDEN_TERMINATION)) {
                    Desktop.getDesktop().enableSuddenTermination();
                }
            }
        }
        if (22 == version) {
            task.setProjectFile(file);
            task.resetModifiedObjects();
        }
    }

    private static void relinkTask(Task task) {
        task.getLayerManager().setTask(task);
        Category rootcat = task.getLayerManager().getRootCatLocal();
        TaskUtil.setParentCat(rootcat, null);
        rootcat.setLayerManager(task.getLayerManager());
        task.getLayerManager().setFiringEvents(true);
    }

    public static void setParentCat(Category cat, Category parentCat) {
        cat.setParentCategory(parentCat);
        for (Category subcat : cat.getSubcategories()) {
            TaskUtil.setParentCat(subcat, cat);
        }
        for (Layerable layerable : new ArrayList<Layerable>(cat.getLayerables())) {
            layerable.setCategory(cat);
            for (StyleCollection styleCollection : layerable.getStyleCollections()) {
                styleCollection.setLayerable(layerable);
            }
        }
    }

    private TaskUtil() {
    }
}

