/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.qa;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.geom.Angle;
import com.vividsolutions.jump.geom.CoordUtil;
import com.vividsolutions.jump.qa.BasicTopologyValidationError;
import com.vividsolutions.jump.qa.ValidationError;
import com.vividsolutions.jump.qa.ValidationErrorType;
import com.vividsolutions.jump.task.TaskMonitor;
import de.riwagis.util.jts.CoordinateArraySupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Supplier;
import org.locationtech.jts.algorithm.CGAlgorithms;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.operation.valid.IsValidOp;
import org.locationtech.jts.operation.valid.RepeatedPointTester;
import org.locationtech.jts.operation.valid.TopologyValidationError;
import org.opengis.feature.simple.SimpleFeature;

public class Validator {
    private int validatedFeatureCount;
    private boolean checkingBasicTopology = true;
    private boolean checkingPolygonOrientation = false;
    private boolean checkingLineStringsSimple = false;
    private boolean checkingMinSegmentLength = false;
    private boolean checkingMinAngle = false;
    private boolean checkingMinPolygonArea = false;
    private boolean checkingNoRepeatedConsecutivePoints = false;
    private boolean checkingNoHoles = false;
    private double minSegmentLength = 0.0;
    private double minAngle = 0.0;
    private double minPolygonArea = 0.0;
    private final Collection<String> disallowedGeometryClassNames = new ArrayList<String>();
    private final RepeatedPointTester repeatedPointTester = new RepeatedPointTester();

    public void setCheckingBasicTopology(boolean checkingBasicTopology) {
        this.checkingBasicTopology = checkingBasicTopology;
    }

    public void setCheckingNoRepeatedConsecutivePoints(boolean checkingNoRepeatedConsecutivePoints) {
        this.checkingNoRepeatedConsecutivePoints = checkingNoRepeatedConsecutivePoints;
    }

    public void setCheckingNoHoles(boolean checkingNoHoles) {
        this.checkingNoHoles = checkingNoHoles;
    }

    public void setCheckingPolygonOrientation(boolean checkingPolygonOrientation) {
        this.checkingPolygonOrientation = checkingPolygonOrientation;
    }

    public void setMinSegmentLength(double minSegmentLength) {
        this.minSegmentLength = minSegmentLength;
    }

    public void setMinAngle(double minAngle) {
        this.minAngle = minAngle;
    }

    public void setMinPolygonArea(double minPolygonArea) {
        this.minPolygonArea = minPolygonArea;
    }

    public void setCheckingLineStringsSimple(boolean checkingLineStringsSimple) {
        this.checkingLineStringsSimple = checkingLineStringsSimple;
    }

    public void setCheckingMinSegmentLength(boolean checkingMinSegmentLength) {
        this.checkingMinSegmentLength = checkingMinSegmentLength;
    }

    public void setCheckingMinAngle(boolean checkingMinAngle) {
        this.checkingMinAngle = checkingMinAngle;
    }

    public void setCheckingMinPolygonArea(boolean checkingMinPolygonArea) {
        this.checkingMinPolygonArea = checkingMinPolygonArea;
    }

    public void setDisallowedGeometryClasses(Collection<Class<?>> disallowedGeometryClasses) {
        this.disallowedGeometryClassNames.clear();
        for (Class<?> c : disallowedGeometryClasses) {
            this.disallowedGeometryClassNames.add(c.getName());
        }
    }

    public Collection<ValidationError> validate(Collection<SimpleFeature> features, TaskMonitor monitor) {
        monitor.allowCancellationRequests();
        monitor.report(I18N.get("qa.Validator.validating"));
        int totalFeatures = features.size();
        return this.validate(features, () -> monitor.isCancelRequested(), () -> monitor.report(++this.validatedFeatureCount, totalFeatures, "features"));
    }

    public Collection<ValidationError> validate(Collection<SimpleFeature> features) {
        return this.validate(features, () -> false, () -> {});
    }

    public Collection<ValidationError> validate(Collection<SimpleFeature> features, Supplier<Boolean> cancelSupplier, Runnable progressInformer) {
        this.validatedFeatureCount = 0;
        ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
        Iterator<SimpleFeature> i = features.iterator();
        while (i.hasNext() && !cancelSupplier.get().booleanValue()) {
            SimpleFeature feature = i.next();
            this.validate(feature, validationErrors);
            progressInformer.run();
        }
        return validationErrors;
    }

    protected void addIfNotNull(ValidationError item, Collection<ValidationError> collection) {
        if (item == null) {
            return;
        }
        collection.add(item);
    }

    protected void validate(SimpleFeature feature, Collection<ValidationError> validationErrors) {
        Geometry geometry = (Geometry)feature.getDefaultGeometry();
        if (geometry == null) {
            return;
        }
        this.addIfNotNull(this.validateGeometryClass(feature), validationErrors);
        if (this.checkingBasicTopology) {
            this.addIfNotNull(this.validateBasicTopology(feature), validationErrors);
        }
        if (this.checkingPolygonOrientation) {
            this.addIfNotNull(this.validatePolygonOrientation(feature), validationErrors);
        }
        if (this.checkingLineStringsSimple) {
            this.addIfNotNull(this.validateLineStringsSimple(feature), validationErrors);
        }
        if (this.checkingMinSegmentLength) {
            this.addIfNotNull(this.validateMinSegmentLength(feature), validationErrors);
        }
        if (this.checkingMinAngle) {
            this.addIfNotNull(this.validateMinAngle(feature), validationErrors);
        }
        if (this.checkingMinPolygonArea) {
            this.addIfNotNull(this.validateMinPolygonArea(feature), validationErrors);
        }
        if (this.checkingNoHoles) {
            this.addIfNotNull(this.validateNoHoles(feature), validationErrors);
        }
        if (this.checkingNoRepeatedConsecutivePoints) {
            this.addIfNotNull(this.validateNoRepeatedConsecutivePoints(feature), validationErrors);
        }
    }

    protected ValidationError validateGeometryClass(SimpleFeature feature) {
        if (this.disallowedGeometryClassNames.contains(feature.getDefaultGeometry().getClass().getName())) {
            return new ValidationError(ValidationErrorType.GEOMETRY_CLASS_DISALLOWED, feature);
        }
        return null;
    }

    protected ValidationError validateBasicTopology(SimpleFeature feature) {
        TopologyValidationError error = new IsValidOp((Geometry)feature.getDefaultGeometry()).getValidationError();
        if (error != null) {
            return new BasicTopologyValidationError(error, feature);
        }
        return null;
    }

    protected ValidationError validateNoRepeatedConsecutivePoints(SimpleFeature feature) {
        if (this.repeatedPointTester.hasRepeatedPoint((Geometry)feature.getDefaultGeometry())) {
            return new ValidationError(ValidationErrorType.REPEATED_CONSECUTIVE_POINTS, feature, this.repeatedPointTester.getCoordinate());
        }
        return null;
    }

    protected ValidationError validateLineStringsSimple(SimpleFeature feature) {
        return this.recursivelyValidate((Geometry)feature.getDefaultGeometry(), feature, new RecursiveValidation(this){

            @Override
            public ValidationError validate(Geometry g, SimpleFeature f) {
                LineString lineString = (LineString)g;
                if (!lineString.isSimple()) {
                    return new ValidationError(ValidationErrorType.NONSIMPLE_LINESTRING, f, (Geometry)lineString);
                }
                return null;
            }

            public Class<LineString> getTargetGeometryClass() {
                return LineString.class;
            }
        });
    }

    protected ValidationError validatePolygonOrientation(SimpleFeature feature) {
        return this.recursivelyValidate((Geometry)feature.getDefaultGeometry(), feature, new RecursiveValidation(this){

            @Override
            public ValidationError validate(Geometry g, SimpleFeature f) {
                Polygon polygon = (Polygon)g;
                if (CGAlgorithms.isCCW((Coordinate[])polygon.getExteriorRing().getCoordinates())) {
                    return new ValidationError(ValidationErrorType.EXTERIOR_RING_CCW, f, (Geometry)polygon);
                }
                for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
                    if (CGAlgorithms.isCCW((Coordinate[])polygon.getInteriorRingN(i).getCoordinates())) continue;
                    return new ValidationError(ValidationErrorType.INTERIOR_RING_CW, f, (Geometry)polygon);
                }
                return null;
            }

            public Class<Polygon> getTargetGeometryClass() {
                return Polygon.class;
            }
        });
    }

    protected ValidationError validateNoHoles(SimpleFeature feature) {
        return this.recursivelyValidate((Geometry)feature.getDefaultGeometry(), feature, new RecursiveValidation(this){

            @Override
            public ValidationError validate(Geometry g, SimpleFeature f) {
                Polygon polygon = (Polygon)g;
                if (polygon.getNumInteriorRing() > 0) {
                    return new ValidationError(ValidationErrorType.POLYGON_HAS_HOLES, f, polygon.getInteriorRingN(0).getCoordinate());
                }
                return null;
            }

            public Class<Polygon> getTargetGeometryClass() {
                return Polygon.class;
            }
        });
    }

    private ValidationError recursivelyValidate(Geometry geometry, SimpleFeature feature, RecursiveValidation validation) {
        if (geometry.isEmpty()) {
            return null;
        }
        if (geometry instanceof GeometryCollection) {
            return this.recursivelyValidateGeometryCollection((GeometryCollection)geometry, feature, validation);
        }
        if (!validation.getTargetGeometryClass().isInstance(geometry)) {
            return null;
        }
        return validation.validate(geometry, feature);
    }

    private ValidationError recursivelyValidateGeometryCollection(GeometryCollection gc, SimpleFeature feature, RecursiveValidation validation) {
        for (int i = 0; i < gc.getNumGeometries(); ++i) {
            ValidationError error = this.recursivelyValidate(gc.getGeometryN(i), feature, validation);
            if (error == null) continue;
            return error;
        }
        return null;
    }

    protected ValidationError validateMinSegmentLength(SimpleFeature feature) {
        Collection arrays = CoordinateArraySupport.toCoordinateArrays((Geometry)((Geometry)feature.getDefaultGeometry()), (boolean)false);
        for (Coordinate[] coordinates : arrays) {
            ValidationError error = this.validateMinSegmentLength(coordinates, feature);
            if (error == null) continue;
            return error;
        }
        return null;
    }

    protected ValidationError validateMinAngle(SimpleFeature feature) {
        Collection arrays = CoordinateArraySupport.toCoordinateArrays((Geometry)((Geometry)feature.getDefaultGeometry()), (boolean)false);
        for (Coordinate[] coordinates : arrays) {
            ValidationError error = this.validateMinAngle(coordinates, feature);
            if (error == null) continue;
            return error;
        }
        return null;
    }

    protected ValidationError validateMinPolygonArea(SimpleFeature feature) {
        return this.recursivelyValidate((Geometry)feature.getDefaultGeometry(), feature, new RecursiveValidation(){

            @Override
            public ValidationError validate(Geometry g, SimpleFeature f) {
                Polygon polygon = (Polygon)g;
                if (polygon.getArea() < Validator.this.minPolygonArea) {
                    return new ValidationError(ValidationErrorType.SMALL_AREA, f, (Geometry)polygon);
                }
                return null;
            }

            public Class<Polygon> getTargetGeometryClass() {
                return Polygon.class;
            }
        });
    }

    private ValidationError validateMinSegmentLength(Coordinate[] coordinates, SimpleFeature feature) {
        if (coordinates.length < 2) {
            return null;
        }
        for (int i = 1; i < coordinates.length; ++i) {
            ValidationError error = this.validateMinSegmentLength(coordinates[i - 1], coordinates[i], feature);
            if (error == null) continue;
            return error;
        }
        return null;
    }

    private ValidationError validateMinAngle(Coordinate[] coordinates, SimpleFeature feature) {
        int i;
        if (coordinates.length < 3) {
            return null;
        }
        boolean closed = coordinates[0].equals((Object)coordinates[coordinates.length - 1]);
        int n = i = closed ? 1 : 2;
        while (i < coordinates.length) {
            ValidationError error = this.validateMinAngle(i == 1 ? coordinates[coordinates.length - 2] : coordinates[i - 2], coordinates[i - 1], coordinates[i], feature);
            if (error != null) {
                return error;
            }
            ++i;
        }
        return null;
    }

    private ValidationError validateMinSegmentLength(Coordinate c1, Coordinate c2, SimpleFeature feature) {
        if (c1.distance(c2) < this.minSegmentLength) {
            return new ValidationError(ValidationErrorType.SMALL_SEGMENT, feature, CoordUtil.average(c1, c2));
        }
        return null;
    }

    private ValidationError validateMinAngle(Coordinate c1, Coordinate c2, Coordinate c3, SimpleFeature feature) {
        if (Angle.angleBetween(c2, c1, c3) < Math.toRadians(this.minAngle)) {
            return new ValidationError(ValidationErrorType.SMALL_ANGLE, feature, c2);
        }
        return null;
    }

    private static interface RecursiveValidation {
        public ValidationError validate(Geometry var1, SimpleFeature var2);

        public Class<? extends Geometry> getTargetGeometryClass();
    }
}

