/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.qa;

import com.vividsolutions.jump.geom.InteriorPointFinder;
import com.vividsolutions.jump.qa.ValidationErrorType;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;

public class ValidationError {
    private static InteriorPointFinder interiorPointFinder = new InteriorPointFinder();
    private ValidationErrorType type;
    private SimpleFeature feature;
    private Coordinate location;

    public ValidationError(ValidationErrorType type, SimpleFeature feature) {
        this(type, feature, ValidationError.location((Geometry)feature.getDefaultGeometry()));
    }

    public ValidationError(ValidationErrorType type, SimpleFeature feature, Coordinate location) {
        this.type = type;
        this.feature = feature;
        this.location = location;
    }

    public ValidationError(ValidationErrorType type, SimpleFeature feature, Geometry badPart) {
        this(type, feature, ValidationError.location(badPart));
    }

    public ValidationErrorType getType() {
        return this.type;
    }

    public String getMessage() {
        return this.type.getMessage();
    }

    public SimpleFeature getFeature() {
        return this.feature;
    }

    public Coordinate getLocation() {
        return this.location;
    }

    private static Coordinate location(Geometry g) {
        try {
            return interiorPointFinder.findPoint(g);
        }
        catch (Exception ex) {
            return interiorPointFinder.centre(g.getEnvelopeInternal());
        }
    }
}

