/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.io;

import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import de.riwagis.service.directory.DirectoryService;
import de.riwagis.service.directory.ProjectType;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionCacheDirectory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SessionCacheDirectory.class);
    private static Path sessionTempDirectory;

    public static synchronized void reset() {
        log.info("Resetting session cache directory");
        sessionTempDirectory = SessionCacheDirectory.create();
    }

    public static synchronized String get() {
        if (sessionTempDirectory == null) {
            sessionTempDirectory = SessionCacheDirectory.create();
        }
        return sessionTempDirectory.toString();
    }

    private static Path create() {
        String bbCachePath = PersistentBlackboardPlugIn.get().get("cache_directory_path", "");
        String homeCachePath = DirectoryService.getInstance().getProjectCacheDirectory(ProjectType.JUMP).getAbsolutePath();
        String cacheDirectory = StringUtils.isEmpty((CharSequence)bbCachePath) ? homeCachePath : bbCachePath;
        try {
            Path cachePath = Paths.get(cacheDirectory, new String[0]);
            Files.createDirectories(cachePath, new FileAttribute[0]);
            Path newSessionTempDirectory = Files.createTempDirectory(cachePath, String.format("riwaclient-cachedir-%s-%s-", SessionCacheDirectory.getHostName(), SessionCacheDirectory.getUserName()), new FileAttribute[0]);
            Runnable cleanRunner = () -> {
                log.info("Deleting {}", (Object)newSessionTempDirectory);
                FileUtils.deleteQuietly((File)newSessionTempDirectory.toFile());
            };
            JUMPWorkbench workbench = JUMPWorkbench.getWorkbench();
            if (workbench != null) {
                workbench.addCloseAppListener(e -> cleanRunner.run());
            } else {
                Runtime.getRuntime().addShutdownHook(new Thread(cleanRunner));
            }
            return newSessionTempDirectory;
        }
        catch (IOException ex) {
            log.error("Could not create session temp directory " + cacheDirectory, (Throwable)ex);
            return Paths.get(homeCachePath, new String[0]);
        }
    }

    private static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            log.warn("Could not determine host name", (Throwable)ex);
            return null;
        }
    }

    private static String getUserName() {
        return System.getProperty("user.name");
    }
}

