/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.io;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.util.Assert;

public class FUTURE_JTS_WKTWriter {
    private static final int INDENT = 2;
    private DecimalFormat formatter;
    private boolean isFormatted = false;
    private final int level = 0;

    private static DecimalFormat createFormatter(PrecisionModel precisionModel) {
        int decimalPlaces = precisionModel.getMaximumSignificantDigits();
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        return new DecimalFormat("#" + (decimalPlaces > 0 ? "." : "") + FUTURE_JTS_WKTWriter.stringOfChar('#', decimalPlaces), symbols);
    }

    public static String stringOfChar(char ch, int count) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < count; ++i) {
            buf.append(ch);
        }
        return buf.toString();
    }

    public String write(Geometry geometry) {
        StringWriter sw = new StringWriter();
        try {
            this.writeFormatted(geometry, false, sw);
        }
        catch (IOException ex) {
            Assert.shouldNeverReachHere();
        }
        return ((Object)sw).toString();
    }

    public void write(Geometry geometry, Writer writer) throws IOException {
        this.writeFormatted(geometry, false, writer);
    }

    public String writeFormatted(Geometry geometry) {
        StringWriter sw = new StringWriter();
        try {
            this.writeFormatted(geometry, true, sw);
        }
        catch (IOException ex) {
            Assert.shouldNeverReachHere();
        }
        return ((Object)sw).toString();
    }

    public void writeFormatted(Geometry geometry, Writer writer) throws IOException {
        this.writeFormatted(geometry, true, writer);
    }

    private void writeFormatted(Geometry geometry, boolean isFormatted, Writer writer) throws IOException {
        if (geometry == null) {
            return;
        }
        this.isFormatted = isFormatted;
        this.formatter = FUTURE_JTS_WKTWriter.createFormatter(geometry.getPrecisionModel());
        this.appendGeometryTaggedText(geometry, 0, writer);
    }

    private void appendGeometryTaggedText(Geometry geometry, int level, Writer writer) throws IOException {
        if (geometry == null) {
            return;
        }
        this.indent(level, writer);
        if (geometry instanceof Point) {
            Point point = (Point)geometry;
            this.appendPointTaggedText(point.getCoordinate(), level, writer, point.getPrecisionModel());
        } else if (geometry instanceof LinearRing) {
            this.appendLinearRingTaggedText((LinearRing)geometry, level, writer);
        } else if (geometry instanceof LineString) {
            this.appendLineStringTaggedText((LineString)geometry, level, writer);
        } else if (geometry instanceof Polygon) {
            this.appendPolygonTaggedText((Polygon)geometry, level, writer);
        } else if (geometry instanceof MultiPoint) {
            this.appendMultiPointTaggedText((MultiPoint)geometry, level, writer);
        } else if (geometry instanceof MultiLineString) {
            this.appendMultiLineStringTaggedText((MultiLineString)geometry, level, writer);
        } else if (geometry instanceof MultiPolygon) {
            this.appendMultiPolygonTaggedText((MultiPolygon)geometry, level, writer);
        } else if (geometry instanceof GeometryCollection) {
            this.appendGeometryCollectionTaggedText((GeometryCollection)geometry, level, writer);
        } else {
            Assert.shouldNeverReachHere((String)("Unsupported Geometry implementation:" + String.valueOf(geometry.getClass())));
        }
    }

    private void appendPointTaggedText(Coordinate coordinate, int level, Writer writer, PrecisionModel precisionModel) throws IOException {
        writer.write("POINT ");
        this.appendPointText(coordinate, level, writer, precisionModel);
    }

    private void appendLineStringTaggedText(LineString lineString, int level, Writer writer) throws IOException {
        writer.write("LINESTRING ");
        this.appendLineStringText(lineString, level, false, writer);
    }

    private void appendLinearRingTaggedText(LinearRing linearRing, int level, Writer writer) throws IOException {
        writer.write("LINEARRING ");
        this.appendLineStringText((LineString)linearRing, level, false, writer);
    }

    private void appendPolygonTaggedText(Polygon polygon, int level, Writer writer) throws IOException {
        writer.write("POLYGON ");
        this.appendPolygonText(polygon, level, false, writer);
    }

    private void appendMultiPointTaggedText(MultiPoint multipoint, int level, Writer writer) throws IOException {
        writer.write("MULTIPOINT ");
        this.appendMultiPointText(multipoint, level, writer);
    }

    private void appendMultiLineStringTaggedText(MultiLineString multiLineString, int level, Writer writer) throws IOException {
        writer.write("MULTILINESTRING ");
        this.appendMultiLineStringText(multiLineString, level, false, writer);
    }

    private void appendMultiPolygonTaggedText(MultiPolygon multiPolygon, int level, Writer writer) throws IOException {
        writer.write("MULTIPOLYGON ");
        this.appendMultiPolygonText(multiPolygon, level, writer);
    }

    private void appendGeometryCollectionTaggedText(GeometryCollection geometryCollection, int level, Writer writer) throws IOException {
        writer.write("GEOMETRYCOLLECTION ");
        this.appendGeometryCollectionText(geometryCollection, level, writer);
    }

    private void appendPointText(Coordinate coordinate, int level, Writer writer, PrecisionModel precisionModel) throws IOException {
        if (coordinate == null) {
            writer.write("EMPTY");
        } else {
            writer.write("(");
            this.appendCoordinate(coordinate, writer, precisionModel);
            writer.write(")");
        }
    }

    private void appendCoordinate(Coordinate coordinate, Writer writer, PrecisionModel precisionModel) throws IOException {
        writer.write(this.writeNumber(coordinate.x) + " " + this.writeNumber(coordinate.y) + (String)(Double.isNaN(coordinate.z) ? "" : " " + this.writeNumber(coordinate.z)));
    }

    private String writeNumber(double d) {
        return this.formatter.format(d);
    }

    private void appendLineStringText(LineString lineString, int level, boolean doIndent, Writer writer) throws IOException {
        if (lineString.isEmpty()) {
            writer.write("EMPTY");
        } else {
            if (doIndent) {
                this.indent(level, writer);
            }
            writer.write("(");
            for (int i = 0; i < lineString.getNumPoints(); ++i) {
                if (i > 0) {
                    writer.write(", ");
                    if (i % 10 == 0) {
                        this.indent(level + 2, writer);
                    }
                }
                this.appendCoordinate(lineString.getCoordinateN(i), writer, lineString.getPrecisionModel());
            }
            writer.write(")");
        }
    }

    private void appendPolygonText(Polygon polygon, int level, boolean indentFirst, Writer writer) throws IOException {
        if (polygon.isEmpty()) {
            writer.write("EMPTY");
        } else {
            if (indentFirst) {
                this.indent(level, writer);
            }
            writer.write("(");
            this.appendLineStringText((LineString)polygon.getExteriorRing(), level, false, writer);
            for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
                writer.write(", ");
                this.appendLineStringText((LineString)polygon.getInteriorRingN(i), level + 1, true, writer);
            }
            writer.write(")");
        }
    }

    private void appendMultiPointText(MultiPoint multiPoint, int level, Writer writer) throws IOException {
        if (multiPoint.isEmpty()) {
            writer.write("EMPTY");
        } else {
            writer.write("(");
            for (int i = 0; i < multiPoint.getNumGeometries(); ++i) {
                if (i > 0) {
                    writer.write(", ");
                }
                this.appendCoordinate(((Point)multiPoint.getGeometryN(i)).getCoordinate(), writer, multiPoint.getPrecisionModel());
            }
            writer.write(")");
        }
    }

    private void appendMultiLineStringText(MultiLineString multiLineString, int level, boolean indentFirst, Writer writer) throws IOException {
        if (multiLineString.isEmpty()) {
            writer.write("EMPTY");
        } else {
            int level2 = level;
            boolean doIndent = indentFirst;
            writer.write("(");
            for (int i = 0; i < multiLineString.getNumGeometries(); ++i) {
                if (i > 0) {
                    writer.write(", ");
                    level2 = level + 1;
                    doIndent = true;
                }
                this.appendLineStringText((LineString)multiLineString.getGeometryN(i), level2, doIndent, writer);
            }
            writer.write(")");
        }
    }

    private void appendMultiPolygonText(MultiPolygon multiPolygon, int level, Writer writer) throws IOException {
        if (multiPolygon.isEmpty()) {
            writer.write("EMPTY");
        } else {
            int level2 = level;
            boolean doIndent = false;
            writer.write("(");
            for (int i = 0; i < multiPolygon.getNumGeometries(); ++i) {
                if (i > 0) {
                    writer.write(", ");
                    level2 = level + 1;
                    doIndent = true;
                }
                this.appendPolygonText((Polygon)multiPolygon.getGeometryN(i), level2, doIndent, writer);
            }
            writer.write(")");
        }
    }

    private void appendGeometryCollectionText(GeometryCollection geometryCollection, int level, Writer writer) throws IOException {
        if (geometryCollection.isEmpty()) {
            writer.write("EMPTY");
        } else {
            int level2 = level;
            writer.write("(");
            for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
                if (i > 0) {
                    writer.write(", ");
                    level2 = level + 1;
                }
                this.appendGeometryTaggedText(geometryCollection.getGeometryN(i), level2, writer);
            }
            writer.write(")");
        }
    }

    private void indent(int level, Writer writer) throws IOException {
        if (!this.isFormatted || level <= 0) {
            return;
        }
        writer.write("\n");
        writer.write(FUTURE_JTS_WKTWriter.stringOfChar(' ', 2 * level));
    }
}

