/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.geom;

import com.vividsolutions.jump.util.MathUtil;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;

public class InteriorPointFinder {
    private final GeometryFactory factory = new GeometryFactory();

    public Coordinate findPoint(Geometry geometry) {
        if (geometry.isEmpty()) {
            return new Coordinate(0.0, 0.0, 0.0);
        }
        if (geometry.getDimension() == 0) {
            return geometry.getCoordinate();
        }
        if (geometry instanceof GeometryCollection) {
            return this.findPoint(((GeometryCollection)geometry).getGeometryN(0));
        }
        Geometry envelopeMiddle = this.envelopeMiddle(geometry);
        if (envelopeMiddle instanceof Point) {
            return envelopeMiddle.getCoordinate();
        }
        Geometry widestIntersection = null;
        try {
            Geometry intersections = envelopeMiddle.intersection(geometry);
            widestIntersection = this.widestGeometry(intersections);
        }
        catch (Exception e) {
            return geometry.getCoordinates()[0];
        }
        return this.centre(widestIntersection.getEnvelopeInternal());
    }

    protected Geometry widestGeometry(Geometry geometry) {
        if (!(geometry instanceof GeometryCollection)) {
            return geometry;
        }
        return this.widestGeometry((GeometryCollection)geometry);
    }

    private Geometry widestGeometry(GeometryCollection gc) {
        if (gc.isEmpty()) {
            return gc;
        }
        Geometry widestGeometry = gc.getGeometryN(0);
        for (int i = 1; i < gc.getNumGeometries(); ++i) {
            if (!(gc.getGeometryN(i).getEnvelopeInternal().getWidth() > widestGeometry.getEnvelopeInternal().getWidth())) continue;
            widestGeometry = gc.getGeometryN(i);
        }
        return widestGeometry;
    }

    protected Geometry envelopeMiddle(Geometry geometry) {
        Envelope envelope = geometry.getEnvelopeInternal();
        if (envelope.getWidth() == 0.0) {
            return this.factory.createPoint(this.centre(envelope));
        }
        return this.factory.createLineString(new Coordinate[]{new Coordinate(envelope.getMinX(), MathUtil.avg(envelope.getMinY(), envelope.getMaxY()), 0.0), new Coordinate(envelope.getMaxX(), MathUtil.avg(envelope.getMinY(), envelope.getMaxY()), 0.0)});
    }

    public Coordinate centre(Envelope envelope) {
        return new Coordinate(MathUtil.avg(envelope.getMinX(), envelope.getMaxX()), MathUtil.avg(envelope.getMinY(), envelope.getMaxY()), 0.0);
    }
}

