/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.geom;

import com.vividsolutions.jump.geom.LineSegmentEnvelopeIntersector;
import com.vividsolutions.jump.geom.MicroscopePointAdjuster;
import de.riwagis.util.jts.CoordinateArraySupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineSegment;

public class GeometryMicroscope {
    private final Collection<Geometry> geomList;
    private final Envelope env;
    private final double minSep;

    public GeometryMicroscope(Collection<Geometry> geomList, Envelope env, double minSep) {
        this.geomList = geomList;
        this.env = env;
        this.minSep = minSep;
    }

    public Collection<Geometry> getAdjusted() {
        Collection<LineSegment> segList = this.getSegList();
        MicroscopePointAdjuster mpa = new MicroscopePointAdjuster(segList, this.env, this.minSep);
        Map<Coordinate, Coordinate> ptMap = mpa.getAdjustedPointMap();
        this.applyAdjustment(ptMap);
        return Collections.unmodifiableCollection(this.geomList);
    }

    private void applyAdjustment(Map<Coordinate, Coordinate> ptMap) {
        CoordinateAdjusterFilter coordAdjFilter = new CoordinateAdjusterFilter(this, ptMap);
        for (Geometry geom : this.geomList) {
            geom.apply((CoordinateFilter)coordAdjFilter);
        }
    }

    private Collection<LineSegment> getSegList() {
        ArrayList<LineSegment> segList = new ArrayList<LineSegment>();
        for (Geometry geom : this.geomList) {
            Collection coordArrayList = CoordinateArraySupport.toCoordinateArrays((Geometry)geom, (boolean)false);
            this.addSegments(coordArrayList, segList);
        }
        return segList;
    }

    private void addSegments(Collection<Coordinate[]> coordArrayList, Collection<LineSegment> segList) {
        LineSegmentEnvelopeIntersector linesegEnvInt = new LineSegmentEnvelopeIntersector();
        for (Coordinate[] coord : coordArrayList) {
            for (int j = 0; j < coord.length - 1; ++j) {
                LineSegment seg = new LineSegment(coord[j], coord[j + 1]);
                if (!linesegEnvInt.touches(seg, this.env)) continue;
                segList.add(seg);
            }
        }
    }

    class CoordinateAdjusterFilter
    implements CoordinateFilter {
        final Map<Coordinate, Coordinate> ptMap;

        CoordinateAdjusterFilter(GeometryMicroscope this$0, Map<Coordinate, Coordinate> ptMap) {
            this.ptMap = ptMap;
        }

        public void filter(Coordinate p) {
            Coordinate adj = this.ptMap.get(p);
            if (adj != null) {
                p.x = adj.x;
                p.y = adj.y;
            }
        }
    }
}

