/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.geom;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryCollectionIterator;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Polygon;

public class GeometryFactoryUtil {
    public static Geometry buildGeometry(Geometry geom, int dimension) {
        GeometryFactory factory = new GeometryFactory(geom.getPrecisionModel(), geom.getSRID());
        if (geom instanceof GeometryCollection) {
            List<?> geomList = GeometryFactoryUtil.dimensionFilter((GeometryCollection)geom, dimension);
            if (geomList.isEmpty()) {
                return GeometryFactoryUtil.getEmptyDimensionalGeometry(factory, dimension);
            }
            return factory.buildGeometry(geomList);
        }
        if (geom.getDimension() == dimension) {
            return geom;
        }
        return GeometryFactoryUtil.getEmptyDimensionalGeometry(factory, dimension);
    }

    public static List<?> dimensionFilter(GeometryCollection gc, int dimension) {
        ArrayList<Geometry> geomList = new ArrayList<Geometry>();
        GeometryCollectionIterator i = new GeometryCollectionIterator((Geometry)gc);
        while (i.hasNext()) {
            Geometry g = (Geometry)i.next();
            if (g instanceof GeometryCollection || g.getDimension() != dimension) continue;
            geomList.add((Geometry)g.clone());
        }
        return geomList;
    }

    public static Geometry getEmptyDimensionalGeometry(GeometryFactory factory, int dimension) {
        switch (dimension) {
            case 0: {
                return factory.createMultiPoint(new Coordinate[0]);
            }
            case 1: {
                return factory.createMultiLineString(new LineString[0]);
            }
            case 2: {
                return factory.createMultiPolygon(new Polygon[0]);
            }
        }
        return factory.createGeometryCollection(new Geometry[0]);
    }
}

