/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.geom;

import com.vividsolutions.jump.util.MathUtil;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;

public class EnvelopeUtil {
    private static final GeometryFactory factory = new GeometryFactory();

    public static Envelope expand(Envelope env, double distance) {
        if (distance < 0.0) {
            double minSize = 2.0 * -distance;
            if (env.getWidth() < minSize) {
                return new Envelope();
            }
            if (env.getHeight() < minSize) {
                return new Envelope();
            }
        }
        return new Envelope(env.getMinX() - distance, env.getMaxX() + distance, env.getMinY() - distance, env.getMaxY() + distance);
    }

    public static void translate(Envelope e, Coordinate displacement) {
        if (e.isNull()) {
            return;
        }
        e.init(e.getMinX() + displacement.x, e.getMaxX() + displacement.x, e.getMinY() + displacement.y, e.getMaxY() + displacement.y);
    }

    public static Envelope bufferByFraction(Envelope originalEnvelope, double extentFraction) {
        Envelope bufferedEnvelope = new Envelope(originalEnvelope);
        double averageExtent = (bufferedEnvelope.getWidth() + bufferedEnvelope.getHeight()) / 2.0;
        double buffer = averageExtent * extentFraction;
        if (averageExtent == 0.0) {
            buffer = 10.0;
        }
        bufferedEnvelope.expandToInclude(bufferedEnvelope.getMaxX() + buffer, bufferedEnvelope.getMaxY() + buffer);
        bufferedEnvelope.expandToInclude(bufferedEnvelope.getMinX() - buffer, bufferedEnvelope.getMinY() - buffer);
        return bufferedEnvelope;
    }

    public static Coordinate centre(Envelope e) {
        return new Coordinate(MathUtil.avg(e.getMinX(), e.getMaxX()), MathUtil.avg(e.getMinY(), e.getMaxY()));
    }

    public static Geometry toGeometry(Envelope envelope) {
        if (envelope.getWidth() == 0.0 && envelope.getHeight() == 0.0) {
            return factory.createPoint(new Coordinate(envelope.getMinX(), envelope.getMinY()));
        }
        if (envelope.getWidth() == 0.0 || envelope.getHeight() == 0.0) {
            return factory.createLineString(new Coordinate[]{new Coordinate(envelope.getMinX(), envelope.getMinY()), new Coordinate(envelope.getMaxX(), envelope.getMaxY())});
        }
        return factory.createPolygon(factory.createLinearRing(new Coordinate[]{new Coordinate(envelope.getMinX(), envelope.getMinY()), new Coordinate(envelope.getMinX(), envelope.getMaxY()), new Coordinate(envelope.getMaxX(), envelope.getMaxY()), new Coordinate(envelope.getMaxX(), envelope.getMinY()), new Coordinate(envelope.getMinX(), envelope.getMinY())}), null);
    }

    public static Envelope getProportionalEnvelope(Envelope envSource, Envelope envTarget) {
        double dblPropGeom;
        double dblProp = envSource.getWidth() / envSource.getHeight();
        if (dblProp > (dblPropGeom = envTarget.getWidth() / envTarget.getHeight())) {
            double newWidth = envTarget.getHeight() * dblProp;
            return new Envelope(envTarget.centre().x - newWidth / 2.0, envTarget.centre().x + newWidth / 2.0, envTarget.getMinY(), envTarget.getMaxY());
        }
        double newHeight = envTarget.getWidth() / dblProp;
        return new Envelope(envTarget.getMinX(), envTarget.getMaxX(), envTarget.centre().y - newHeight / 2.0, envTarget.centre().y + newHeight / 2.0);
    }

    private EnvelopeUtil() {
    }
}

