/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.geom;

import com.vividsolutions.jump.util.MathUtil;
import java.awt.geom.Point2D;
import java.util.Collection;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.util.Assert;

public class CoordUtil {
    private static boolean is3d(Coordinate c) {
        return !Double.isNaN(c.z);
    }

    public static void absorbZ(Coordinate oldC, Coordinate newC) {
        if (!Double.isNaN(oldC.z)) {
            newC.z = oldC.z;
        }
    }

    public static void absorbZ(Coordinate oldC, Coordinate[] newC) {
        if (!Double.isNaN(oldC.z)) {
            for (Coordinate newC1 : newC) {
                newC1.z = oldC.z;
            }
        }
    }

    public static void absorbZ(Coordinate[] oldC, Coordinate[] newC) {
        double dblZ = 0.0;
        for (Coordinate oldC1 : oldC) {
            if (Double.isNaN(oldC1.z)) continue;
            dblZ += oldC1.z;
        }
        dblZ /= (double)oldC.length;
        for (Coordinate newC1 : newC) {
            newC1.z = dblZ;
        }
    }

    public static Coordinate average(Coordinate c1, Coordinate c2) {
        return new Coordinate(MathUtil.avg(c1.x, c2.x), MathUtil.avg(c1.y, c2.y), c1.z);
    }

    public static Coordinate average(Collection coordinates) {
        Assert.isTrue((!coordinates.isEmpty() ? 1 : 0) != 0);
        double xSum = 0.0;
        double ySum = 0.0;
        double zSum = 0.0;
        boolean bolUse3D = true;
        for (Coordinate coordinate : coordinates) {
            xSum += coordinate.x;
            ySum += coordinate.y;
            if (CoordUtil.is3d(coordinate)) {
                zSum += coordinate.z;
                continue;
            }
            bolUse3D = false;
        }
        if (bolUse3D) {
            return new Coordinate(xSum / (double)coordinates.size(), ySum / (double)coordinates.size(), zSum / (double)coordinates.size());
        }
        return new Coordinate(xSum / (double)coordinates.size(), ySum / (double)coordinates.size());
    }

    public static Coordinate closest(Collection coordinates, Coordinate p) {
        Assert.isTrue((!coordinates.isEmpty() ? 1 : 0) != 0);
        Coordinate closest = (Coordinate)coordinates.iterator().next();
        for (Coordinate candidate : coordinates) {
            if (!(p.distance(candidate) < p.distance(closest))) continue;
            closest = candidate;
        }
        if (!CoordUtil.is3d(closest = new Coordinate(closest))) {
            closest.z = 0.0;
        }
        return closest;
    }

    public static Coordinate add(Coordinate c1, Coordinate c2) {
        return new Coordinate(c1.x + c2.x, c1.y + c2.y, c1.z);
    }

    public static Coordinate subtract(Coordinate c1, Coordinate c2) {
        return new Coordinate(c1.x - c2.x, c1.y - c2.y, c1.z);
    }

    public static Coordinate multiply(double d, Coordinate c) {
        return new Coordinate(d * c.x, d * c.y, c.z);
    }

    public static Coordinate divide(Coordinate c, double d) {
        return new Coordinate(c.x / d, c.y / d, c.z);
    }

    public static Coordinate toCoordinate(Point2D point) {
        return new Coordinate(point.getX(), point.getY(), 0.0);
    }

    public static Point2D toPoint2D(Coordinate coordinate) {
        return new Point2D.Double(coordinate.x, coordinate.y);
    }

    public static Point2D add(Point2D a, Point2D b) {
        return new Point2D.Double(a.getX() + b.getX(), a.getY() + b.getY());
    }

    public static Point2D subtract(Point2D a, Point2D b) {
        return new Point2D.Double(a.getX() - b.getX(), a.getY() - b.getY());
    }

    private CoordUtil() {
    }
}

