/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.geom;

import com.vividsolutions.jump.geom.OrientationDirection;
import org.locationtech.jts.geom.Coordinate;

public class Angle {
    public static final double PI_TIMES_2 = Math.PI * 2;
    public static final double PI_OVER_2 = 1.5707963267948966;
    public static final double PI_OVER_4 = 0.7853981633974483;

    @Deprecated
    public static double toDegrees(double radians) {
        return Math.toDegrees(radians);
    }

    public static double angle(Coordinate p0, Coordinate p1) {
        double dx = p1.x - p0.x;
        double dy = p1.y - p0.y;
        return Math.atan2(dy, dx);
    }

    @Deprecated
    public static double toRadians(double angleDegrees) {
        return Math.toRadians(angleDegrees);
    }

    public static double angleBetween(Coordinate tail, Coordinate tip1, Coordinate tip2) {
        double a1 = Angle.angle(tail, tip1);
        double a2 = Angle.angle(tail, tip2);
        return Angle.diff(a1, a2);
    }

    public static double interiorAngle(Coordinate p0, Coordinate p1, Coordinate p2) {
        double anglePrev = Angle.angle(p1, p0);
        double angleNext = Angle.angle(p1, p2);
        return Math.abs(angleNext - anglePrev);
    }

    public static OrientationDirection getTurn(double a1, double a2) {
        double crossproduct = Math.sin(a2 - a1);
        if (crossproduct > 0.0) {
            return OrientationDirection.COUNTERCLOCKWISE;
        }
        if (crossproduct < 0.0) {
            return OrientationDirection.CLOCKWISE;
        }
        return OrientationDirection.NONE;
    }

    public static double normalize(double angle) {
        double angleTmp;
        for (angleTmp = angle; angleTmp > Math.PI; angleTmp -= Math.PI * 2) {
        }
        while (angleTmp < -Math.PI) {
            angleTmp += Math.PI * 2;
        }
        return angleTmp;
    }

    public static double diff(double a1, double a2) {
        double da = a1 < a2 ? a2 - a1 : a1 - a2;
        if (da > Math.PI) {
            da = Math.PI * 2 - da;
        }
        return da;
    }

    private Angle() {
    }
}

