/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump;

import com.vividsolutions.jump.workbench.JUMPWorkbench;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class I18N {
    private static final Logger LOG = LoggerFactory.getLogger(I18N.class);
    private static ResourceBundle rb = ResourceBundle.getBundle("language/jump");

    private I18N() {
    }

    public static final I18N getInstance() {
        return SingletonHolder._singleton;
    }

    public static void loadFile(String langcountry) {
        String lang = langcountry.split("_")[0];
        LOG.debug(lang);
        try {
            String country = langcountry.split("_")[1];
            LOG.debug(country);
            Locale locale = new Locale(lang, country);
            rb = ResourceBundle.getBundle("language/jump", locale);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            LOG.debug(e.getMessage());
            Locale locale = new Locale(lang);
            rb = ResourceBundle.getBundle("language/jump", locale);
        }
    }

    public static String get(String label) {
        try {
            return rb.getString(label);
        }
        catch (MissingResourceException e) {
            String default_translation = ResourceBundle.getBundle("com.vividsolutions.jump.jump").getString(label);
            LOG.debug(e.getMessage() + " default_value:" + default_translation);
            return default_translation;
        }
    }

    public static String getLocale() {
        return rb.getLocale().getLanguage() + "_" + rb.getLocale().getCountry();
    }

    public static String getLanguage() {
        if (StringUtils.isBlank((CharSequence)JUMPWorkbench.I18N_SETLOCALE)) {
            return rb.getLocale().getLanguage();
        }
        return JUMPWorkbench.I18N_SETLOCALE.split("_")[0];
    }

    public static String getMessage(String label, Object ... objects) {
        try {
            MessageFormat mf = new MessageFormat(rb.getString(label));
            return mf.format(objects);
        }
        catch (MissingResourceException e) {
            String default_translation = ResourceBundle.getBundle("com.vividsolutions.jump.jump").getString(label);
            LOG.debug(e.getMessage() + " default_value:" + default_translation);
            MessageFormat mf = new MessageFormat(default_translation);
            return mf.format(objects);
        }
    }

    private static final class SingletonHolder {
        public static final I18N _singleton = new I18N();

        private SingletonHolder() {
        }
    }
}

