/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.marineapi.nmea.parser.SentenceParser;
import net.sf.marineapi.nmea.sentence.SentenceId;
import net.sf.marineapi.nmea.sentence.TalkerId;
import net.sf.marineapi.nmea.sentence.XDRSentence;
import net.sf.marineapi.nmea.util.Measurement;

class XDRParser
extends SentenceParser
implements XDRSentence {
    private static int DATA_SET_LENGTH = 4;
    private static int TYPE_INDEX = 0;
    private static int VALUE_INDEX = 1;
    private static int UNITS_INDEX = 2;
    private static int NAME_INDEX = 3;

    public XDRParser(String nmea) {
        super(nmea, SentenceId.XDR);
    }

    public XDRParser(TalkerId talker) {
        super(talker, SentenceId.XDR, DATA_SET_LENGTH);
    }

    @Override
    public void addMeasurement(Measurement ... m) {
        List<Measurement> ms = this.getMeasurements();
        ms.addAll(Arrays.asList(m));
        this.setMeasurements(ms);
    }

    @Override
    public List<Measurement> getMeasurements() {
        ArrayList<Measurement> result = new ArrayList<Measurement>();
        for (int i = 0; i < this.getFieldCount(); i += DATA_SET_LENGTH) {
            Measurement value = this.fetchValues(i);
            if (value.isEmpty()) continue;
            result.add(value);
        }
        return result;
    }

    @Override
    public void setMeasurement(Measurement m) {
        this.setFieldCount(DATA_SET_LENGTH);
        this.insertValues(TYPE_INDEX, m);
    }

    @Override
    public void setMeasurements(List<Measurement> measurements) {
        this.setFieldCount(measurements.size() * DATA_SET_LENGTH);
        int i = 0;
        for (Measurement m : measurements) {
            this.insertValues(i, m);
            i += DATA_SET_LENGTH;
        }
    }

    private Measurement fetchValues(int i) {
        Measurement m = new Measurement();
        if (this.hasValue(i)) {
            m.setType(this.getStringValue(i));
        }
        if (this.hasValue(i + VALUE_INDEX)) {
            m.setValue(this.getDoubleValue(i + VALUE_INDEX));
        }
        if (this.hasValue(i + UNITS_INDEX)) {
            m.setUnits(this.getStringValue(i + UNITS_INDEX));
        }
        if (this.hasValue(i + NAME_INDEX)) {
            m.setName(this.getStringValue(i + NAME_INDEX));
        }
        return m;
    }

    private void insertValues(int i, Measurement m) {
        if (m != null) {
            this.setStringValue(i, m.getType());
            this.setDoubleValue(i + VALUE_INDEX, m.getValue());
            this.setStringValue(i + UNITS_INDEX, m.getUnits());
            this.setStringValue(i + NAME_INDEX, m.getName());
        }
    }
}

