/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.parser;

import net.sf.marineapi.nmea.parser.SentenceParser;
import net.sf.marineapi.nmea.sentence.SentenceId;
import net.sf.marineapi.nmea.sentence.TalkerId;
import net.sf.marineapi.nmea.sentence.VWRSentence;
import net.sf.marineapi.nmea.util.Direction;

class VWRParser
extends SentenceParser
implements VWRSentence {
    private static final int WIND_ANGLE_DEGREES = 0;
    private static final int WIND_DIRECTION_LEFT_RIGHT_OF_BOW = 1;
    private static final int SPEED_KNOTS = 2;
    private static final int KNOTS_INDICATOR = 3;
    private static final int SPEED_MPS = 4;
    private static final int MPS_INDICATOR = 5;
    private static final int SPEED_KMPH = 6;
    private static final int KMPH_INDICATOR = 7;

    public VWRParser(String nmea) {
        super(nmea, SentenceId.VWR);
    }

    public VWRParser(TalkerId talker) {
        super(talker, SentenceId.VWR, 9);
        this.setCharValue(3, 'N');
        this.setCharValue(5, 'M');
        this.setCharValue(7, 'K');
    }

    @Override
    public double getWindAngle() {
        return this.getDoubleValue(0);
    }

    @Override
    public Direction getDirectionLeftRight() {
        return Direction.valueOf(this.getCharValue(1));
    }

    @Override
    public double getSpeedKmh() {
        return this.getDoubleValue(6);
    }

    @Override
    public double getSpeedKnots() {
        return this.getDoubleValue(2);
    }

    public double getTrueCourse() {
        return this.getDoubleValue(4);
    }

    @Override
    public void setSpeedKmh(double kmh) {
        if (kmh < 0.0) {
            throw new IllegalArgumentException("Speed cannot be negative");
        }
        this.setDoubleValue(6, kmh, 1, 2);
    }

    @Override
    public void setSpeedKnots(double knots) {
        if (knots < 0.0) {
            throw new IllegalArgumentException("Speed cannot be negative");
        }
        this.setDoubleValue(2, knots, 1, 2);
    }

    @Override
    public void setWindAngle(double mWindAngle) {
        this.setDegreesValue(0, mWindAngle);
    }

    @Override
    public void setDirectionLeftRight(Direction directionLeftRight) {
        this.setCharValue(1, directionLeftRight.toChar());
    }
}

