/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.parser;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.marineapi.nmea.parser.DataNotAvailableException;
import net.sf.marineapi.nmea.parser.ParseException;
import net.sf.marineapi.nmea.sentence.Checksum;
import net.sf.marineapi.nmea.sentence.Sentence;
import net.sf.marineapi.nmea.sentence.SentenceId;
import net.sf.marineapi.nmea.sentence.SentenceValidator;
import net.sf.marineapi.nmea.sentence.TalkerId;

public class SentenceParser
implements Sentence {
    private char beginChar;
    private TalkerId talkerId;
    private final String sentenceId;
    private List<String> fields = new ArrayList<String>();

    public SentenceParser(String nmea) {
        if (!SentenceValidator.isValid(nmea)) {
            String msg = String.format("Invalid data [%s]", nmea);
            throw new IllegalArgumentException(msg);
        }
        this.beginChar = nmea.charAt(0);
        this.talkerId = TalkerId.parse(nmea);
        this.sentenceId = SentenceId.parseStr(nmea);
        int begin = nmea.indexOf(44) + 1;
        int end = Checksum.index(nmea);
        String csv = nmea.substring(begin, end);
        String[] values = csv.split(String.valueOf(','), -1);
        this.fields.addAll(Arrays.asList(values));
    }

    protected SentenceParser(char begin, TalkerId tid, SentenceId sid, int size) {
        this(begin, tid, sid.toString(), size);
    }

    protected SentenceParser(char begin, TalkerId talker, String type, int size) {
        if (size < 1) {
            throw new IllegalArgumentException("Minimum number of fields is 1");
        }
        if (talker == null) {
            throw new IllegalArgumentException("Talker ID must be specified");
        }
        if (type == null || "".equals(type)) {
            throw new IllegalArgumentException("Sentence ID must be specified");
        }
        this.beginChar = begin;
        this.talkerId = talker;
        this.sentenceId = type;
        Object[] values = new String[size];
        Arrays.fill(values, "");
        this.fields.addAll(Arrays.asList(values));
    }

    protected SentenceParser(String nmea, String type) {
        this(nmea);
        if (type == null || "".equals(type)) {
            throw new IllegalArgumentException("Sentence type must be specified.");
        }
        String sid = this.getSentenceId();
        if (!sid.equals(type)) {
            String ptrn = "Sentence id mismatch; expected [%s], found [%s].";
            String msg = String.format(ptrn, type, sid);
            throw new IllegalArgumentException(msg);
        }
    }

    protected SentenceParser(TalkerId talker, String type, int size) {
        this('$', talker, type, size);
    }

    SentenceParser(String nmea, SentenceId type) {
        this(nmea, type.toString());
    }

    SentenceParser(TalkerId tid, SentenceId sid, int size) {
        this(tid, sid.toString(), size);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SentenceParser) {
            SentenceParser sp = (SentenceParser)obj;
            return sp.toString().equals(this.toString());
        }
        return false;
    }

    @Override
    public final char getBeginChar() {
        return this.beginChar;
    }

    @Override
    public final int getFieldCount() {
        if (this.fields == null) {
            return 0;
        }
        return this.fields.size();
    }

    @Override
    public final String getSentenceId() {
        return this.sentenceId;
    }

    @Override
    public final TalkerId getTalkerId() {
        return this.talkerId;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public boolean isAISSentence() {
        String[] types = new String[]{"VDO", "VDM"};
        return Arrays.asList(types).contains(this.getSentenceId());
    }

    @Override
    public boolean isProprietary() {
        return TalkerId.P.equals((Object)this.getTalkerId());
    }

    @Override
    public boolean isValid() {
        return SentenceValidator.isValid(this.toString());
    }

    @Override
    public final void reset() {
        for (int i = 0; i < this.fields.size(); ++i) {
            this.fields.set(i, "");
        }
    }

    @Override
    public void setBeginChar(char ch) {
        if (ch != '$' && ch != '!') {
            String msg = "Invalid begin char; expected '$' or '!'";
            throw new IllegalArgumentException(msg);
        }
        this.beginChar = ch;
    }

    @Override
    public final void setTalkerId(TalkerId id) {
        this.talkerId = id;
    }

    @Override
    public final String toSentence() {
        String s = this.toString();
        if (!SentenceValidator.isValid(s)) {
            String msg = String.format("Validation failed [%s]", this.toString());
            throw new IllegalStateException(msg);
        }
        return s;
    }

    @Override
    public final String toSentence(int maxLength) {
        String s = this.toSentence();
        if (s.length() > maxLength) {
            String msg = "Sentence max length exceeded " + maxLength;
            throw new IllegalStateException(msg);
        }
        return s;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(82);
        sb.append(this.talkerId.toString());
        sb.append(this.sentenceId);
        for (String field : this.fields) {
            sb.append(',');
            sb.append(field == null ? "" : field);
        }
        String checksum = Checksum.xor(sb.toString());
        sb.append('*');
        sb.append(checksum);
        sb.insert(0, this.beginChar);
        return sb.toString();
    }

    protected final char getCharValue(int index) {
        String val = this.getStringValue(index);
        if (val.length() > 1) {
            String msg = String.format("Expected char, found String [%s]", val);
            throw new ParseException(msg);
        }
        return val.charAt(0);
    }

    protected final double getDoubleValue(int index) {
        double value;
        try {
            value = Double.parseDouble(this.getStringValue(index));
        }
        catch (NumberFormatException ex) {
            throw new ParseException("Field does not contain double value", ex);
        }
        return value;
    }

    protected final int getIntValue(int index) {
        int value;
        try {
            value = Integer.parseInt(this.getStringValue(index));
        }
        catch (NumberFormatException ex) {
            throw new ParseException("Field does not contain integer value", ex);
        }
        return value;
    }

    protected final String getStringValue(int index) {
        String value = this.fields.get(index);
        if (value == null || "".equals(value)) {
            throw new DataNotAvailableException("Data not available");
        }
        return value;
    }

    protected final boolean hasValue(int index) {
        return this.fields.size() > index && this.fields.get(index) != null && !this.fields.get(index).isEmpty();
    }

    protected final void setCharValue(int index, char value) {
        this.setStringValue(index, String.valueOf(value));
    }

    protected final void setDegreesValue(int index, double deg) {
        if (deg < 0.0 || deg > 360.0) {
            throw new IllegalArgumentException("Value out of bounds [0..360]");
        }
        this.setDoubleValue(index, deg, 3, 1);
    }

    protected final void setDoubleValue(int index, double value) {
        this.setStringValue(index, String.valueOf(value));
    }

    protected final void setDoubleValue(int index, double value, int leading, int decimals) {
        int i;
        StringBuilder pattern = new StringBuilder();
        for (i = 0; i < leading; ++i) {
            pattern.append('0');
        }
        if (decimals > 0) {
            pattern.append('.');
            for (i = 0; i < decimals; ++i) {
                pattern.append('0');
            }
        }
        if (pattern.length() == 0) {
            pattern.append('0');
        }
        DecimalFormat nf = new DecimalFormat(pattern.toString());
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        nf.setDecimalFormatSymbols(dfs);
        this.setStringValue(index, nf.format(value));
    }

    protected final void setFieldCount(int size) {
        if (size < 1) {
            throw new IllegalArgumentException("Number of fields must be greater than zero.");
        }
        if (size < this.fields.size()) {
            this.fields = this.fields.subList(0, size);
        } else if (size > this.fields.size()) {
            for (int i = this.fields.size(); i < size; ++i) {
                this.fields.add("");
            }
        }
    }

    protected final void setIntValue(int index, int value) {
        this.setStringValue(index, String.valueOf(value));
    }

    protected final void setIntValue(int index, int value, int leading) {
        String pattern = "%d";
        if (leading > 0) {
            pattern = "%0" + leading + "d";
        }
        this.setStringValue(index, String.format(pattern, value));
    }

    protected final void setStringValue(int index, String value) {
        this.fields.set(index, value == null ? "" : value);
    }

    protected final void setStringValues(int first, String[] newFields) {
        ArrayList<String> temp = new ArrayList<String>();
        temp.addAll(this.fields.subList(0, first));
        for (String field : newFields) {
            temp.add(field == null ? "" : field);
        }
        this.fields.clear();
        this.fields = temp;
    }

    protected final String[] getStringValues(int first) {
        String[] values = new String[this.fields.size() - first];
        return this.fields.subList(first, this.fields.size()).toArray(values);
    }
}

