/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.parser;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.marineapi.nmea.parser.APBParser;
import net.sf.marineapi.nmea.parser.BODParser;
import net.sf.marineapi.nmea.parser.CURParser;
import net.sf.marineapi.nmea.parser.DBTParser;
import net.sf.marineapi.nmea.parser.DPTParser;
import net.sf.marineapi.nmea.parser.DTAParser;
import net.sf.marineapi.nmea.parser.DTBParser;
import net.sf.marineapi.nmea.parser.DTMParser;
import net.sf.marineapi.nmea.parser.GBSParser;
import net.sf.marineapi.nmea.parser.GGAParser;
import net.sf.marineapi.nmea.parser.GLLParser;
import net.sf.marineapi.nmea.parser.GNSParser;
import net.sf.marineapi.nmea.parser.GSAParser;
import net.sf.marineapi.nmea.parser.GSTParser;
import net.sf.marineapi.nmea.parser.GSVParser;
import net.sf.marineapi.nmea.parser.HDGParser;
import net.sf.marineapi.nmea.parser.HDMParser;
import net.sf.marineapi.nmea.parser.HDTParser;
import net.sf.marineapi.nmea.parser.HTCParser;
import net.sf.marineapi.nmea.parser.HTDParser;
import net.sf.marineapi.nmea.parser.MDAParser;
import net.sf.marineapi.nmea.parser.MHUParser;
import net.sf.marineapi.nmea.parser.MMBParser;
import net.sf.marineapi.nmea.parser.MTAParser;
import net.sf.marineapi.nmea.parser.MTWParser;
import net.sf.marineapi.nmea.parser.MWDParser;
import net.sf.marineapi.nmea.parser.MWVParser;
import net.sf.marineapi.nmea.parser.RMBParser;
import net.sf.marineapi.nmea.parser.RMCParser;
import net.sf.marineapi.nmea.parser.ROTParser;
import net.sf.marineapi.nmea.parser.RPMParser;
import net.sf.marineapi.nmea.parser.RSAParser;
import net.sf.marineapi.nmea.parser.RTEParser;
import net.sf.marineapi.nmea.parser.STALKParser;
import net.sf.marineapi.nmea.parser.SentenceParser;
import net.sf.marineapi.nmea.parser.TTMParser;
import net.sf.marineapi.nmea.parser.TXTParser;
import net.sf.marineapi.nmea.parser.UnsupportedSentenceException;
import net.sf.marineapi.nmea.parser.VBWParser;
import net.sf.marineapi.nmea.parser.VDMParser;
import net.sf.marineapi.nmea.parser.VDOParser;
import net.sf.marineapi.nmea.parser.VDRParser;
import net.sf.marineapi.nmea.parser.VHWParser;
import net.sf.marineapi.nmea.parser.VLWParser;
import net.sf.marineapi.nmea.parser.VTGParser;
import net.sf.marineapi.nmea.parser.VWRParser;
import net.sf.marineapi.nmea.parser.VWTParser;
import net.sf.marineapi.nmea.parser.WPLParser;
import net.sf.marineapi.nmea.parser.XDRParser;
import net.sf.marineapi.nmea.parser.XTEParser;
import net.sf.marineapi.nmea.parser.ZDAParser;
import net.sf.marineapi.nmea.sentence.Sentence;
import net.sf.marineapi.nmea.sentence.SentenceId;
import net.sf.marineapi.nmea.sentence.TalkerId;

public final class SentenceFactory {
    private static Map<String, Class<? extends SentenceParser>> parsers;
    private static final SentenceFactory INSTANCE;

    private SentenceFactory() {
        this.reset();
    }

    public Sentence createParser(String nmea) {
        String sid = SentenceId.parseStr(nmea);
        return this.createParserImpl(sid, nmea);
    }

    public Sentence createParser(TalkerId talker, SentenceId type) {
        return this.createParser(talker, type.toString());
    }

    public Sentence createParser(TalkerId talker, String type) {
        if (talker == null) {
            throw new IllegalArgumentException("TalkerId cannot be null");
        }
        return this.createParserImpl(type, (Object)talker);
    }

    public boolean hasParser(String type) {
        return parsers.containsKey(type);
    }

    public List<String> listParsers() {
        Set<String> keys = parsers.keySet();
        return Arrays.asList(keys.toArray(new String[parsers.size()]));
    }

    public void registerParser(String type, Class<? extends SentenceParser> parser) {
        this.registerParser(parsers, type, parser);
    }

    private void registerParser(Map<String, Class<? extends SentenceParser>> parsers, String type, Class<? extends SentenceParser> parser) {
        try {
            parser.getConstructor(String.class);
            parser.getConstructor(TalkerId.class);
            parsers.put(type, parser);
        }
        catch (SecurityException e) {
            String msg = "Unable to register parser due security violation";
            throw new IllegalArgumentException(msg, e);
        }
        catch (NoSuchMethodException e) {
            String msg = "Required constructors not found; SentenceParser(String), SentenceParser(TalkerId)";
            throw new IllegalArgumentException(msg, e);
        }
    }

    public void unregisterParser(Class<? extends SentenceParser> parser) {
        for (String key : parsers.keySet()) {
            if (parsers.get(key) != parser) continue;
            parsers.remove(key);
            break;
        }
    }

    private Sentence createParserImpl(String sid, Object param) {
        if (!this.hasParser(sid)) {
            String msg = String.format("Parser for type '%s' not found", sid);
            throw new UnsupportedSentenceException(msg);
        }
        Sentence parser = null;
        Class<?> klass = param.getClass();
        try {
            Class<? extends SentenceParser> c = parsers.get(sid);
            Constructor<? extends SentenceParser> co = c.getConstructor(klass);
            parser = co.newInstance(param);
        }
        catch (NoSuchMethodException e) {
            String name = klass.getName();
            String msg = "Constructor with %s parameter not found";
            throw new IllegalStateException(String.format(msg, name), e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Unable to instantiate parser", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Unable to access parser", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("Unable to invoke parser constructor", e);
        }
        return parser;
    }

    public static SentenceFactory getInstance() {
        return INSTANCE;
    }

    public void reset() {
        ConcurrentHashMap<String, Class<? extends SentenceParser>> tempParsers = new ConcurrentHashMap<String, Class<? extends SentenceParser>>();
        this.registerParser(tempParsers, "APB", APBParser.class);
        this.registerParser(tempParsers, "ALK", STALKParser.class);
        this.registerParser(tempParsers, "BOD", BODParser.class);
        this.registerParser(tempParsers, "CUR", CURParser.class);
        this.registerParser(tempParsers, "DBT", DBTParser.class);
        this.registerParser(tempParsers, "DPT", DPTParser.class);
        this.registerParser(tempParsers, "DTM", DTMParser.class);
        this.registerParser(tempParsers, "GBS", GBSParser.class);
        this.registerParser(tempParsers, "GGA", GGAParser.class);
        this.registerParser(tempParsers, "GLL", GLLParser.class);
        this.registerParser(tempParsers, "GNS", GNSParser.class);
        this.registerParser(tempParsers, "GSA", GSAParser.class);
        this.registerParser(tempParsers, "GST", GSTParser.class);
        this.registerParser(tempParsers, "GSV", GSVParser.class);
        this.registerParser(tempParsers, "HDG", HDGParser.class);
        this.registerParser(tempParsers, "HDM", HDMParser.class);
        this.registerParser(tempParsers, "HDT", HDTParser.class);
        this.registerParser(tempParsers, "HTC", HTCParser.class);
        this.registerParser(tempParsers, "HTD", HTDParser.class);
        this.registerParser(tempParsers, "MHU", MHUParser.class);
        this.registerParser(tempParsers, "MMB", MMBParser.class);
        this.registerParser(tempParsers, "MTA", MTAParser.class);
        this.registerParser(tempParsers, "MTW", MTWParser.class);
        this.registerParser(tempParsers, "MWV", MWVParser.class);
        this.registerParser(tempParsers, "RMB", RMBParser.class);
        this.registerParser(tempParsers, "RMC", RMCParser.class);
        this.registerParser(tempParsers, "RPM", RPMParser.class);
        this.registerParser(tempParsers, "ROT", ROTParser.class);
        this.registerParser(tempParsers, "RTE", RTEParser.class);
        this.registerParser(tempParsers, "RSA", RSAParser.class);
        this.registerParser(tempParsers, "TTM", TTMParser.class);
        this.registerParser(tempParsers, "TXT", TXTParser.class);
        this.registerParser(tempParsers, "VBW", VBWParser.class);
        this.registerParser(tempParsers, "VDM", VDMParser.class);
        this.registerParser(tempParsers, "VDO", VDOParser.class);
        this.registerParser(tempParsers, "VDR", VDRParser.class);
        this.registerParser(tempParsers, "VHW", VHWParser.class);
        this.registerParser(tempParsers, "VLW", VLWParser.class);
        this.registerParser(tempParsers, "VTG", VTGParser.class);
        this.registerParser(tempParsers, "VWR", VWRParser.class);
        this.registerParser(tempParsers, "VWT", VWTParser.class);
        this.registerParser(tempParsers, "WPL", WPLParser.class);
        this.registerParser(tempParsers, "XTE", XTEParser.class);
        this.registerParser(tempParsers, "XDR", XDRParser.class);
        this.registerParser(tempParsers, "ZDA", ZDAParser.class);
        this.registerParser(tempParsers, "MDA", MDAParser.class);
        this.registerParser(tempParsers, "MWD", MWDParser.class);
        this.registerParser(tempParsers, "DTA", DTAParser.class);
        this.registerParser(tempParsers, "DTB", DTBParser.class);
        parsers = tempParsers;
    }

    static {
        INSTANCE = new SentenceFactory();
    }
}

