/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.parser;

import net.sf.marineapi.nmea.parser.SentenceParser;
import net.sf.marineapi.nmea.sentence.GBSSentence;
import net.sf.marineapi.nmea.sentence.SentenceId;
import net.sf.marineapi.nmea.sentence.TalkerId;
import net.sf.marineapi.nmea.util.Time;

class GBSParser
extends SentenceParser
implements GBSSentence {
    private static final int UTC = 0;
    private static final int LAT_ERROR = 1;
    private static final int LON_ERROR = 2;
    private static final int ALT_ERROR = 3;
    private static final int SATELLITE_ID = 4;
    private static final int PROBABILITY = 5;
    private static final int ESTIMATE = 6;
    private static final int DEVIATION = 7;

    public GBSParser(TalkerId tid) {
        super(tid, SentenceId.GBS, 8);
    }

    public GBSParser(String nmea) {
        super(nmea, SentenceId.GBS);
    }

    @Override
    public double getLatitudeError() {
        return this.getDoubleValue(1);
    }

    @Override
    public void setLatitudeError(double err) {
        this.setDoubleValue(1, err);
    }

    @Override
    public double getLongitudeError() {
        return this.getDoubleValue(2);
    }

    @Override
    public void setLongitudeError(double err) {
        this.setDoubleValue(2, err);
    }

    @Override
    public double getAltitudeError() {
        return this.getDoubleValue(3);
    }

    @Override
    public void setAltitudeError(double err) {
        this.setDoubleValue(3, err);
    }

    @Override
    public String getSatelliteId() {
        return this.getStringValue(4);
    }

    @Override
    public void setSatelliteId(String id) {
        this.setStringValue(4, id);
    }

    @Override
    public double getProbability() {
        return this.getDoubleValue(5);
    }

    @Override
    public void setProbability(double probability) {
        this.setDoubleValue(5, probability);
    }

    @Override
    public double getEstimate() {
        return this.getDoubleValue(6);
    }

    @Override
    public void setEstimate(double estimate) {
        this.setDoubleValue(6, estimate);
    }

    @Override
    public double getDeviation() {
        return this.getDoubleValue(7);
    }

    @Override
    public void setDeviation(double deviation) {
        this.setDoubleValue(7, deviation);
    }

    @Override
    public Time getTime() {
        return new Time(this.getStringValue(0));
    }

    @Override
    public void setTime(Time t) {
        this.setStringValue(0, t.toString());
    }
}

