/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.parser;

import net.sf.marineapi.nmea.parser.SentenceParser;
import net.sf.marineapi.nmea.sentence.CURSentence;
import net.sf.marineapi.nmea.sentence.SentenceId;
import net.sf.marineapi.nmea.sentence.TalkerId;

class CURParser
extends SentenceParser
implements CURSentence {
    private static final int DATA_STATUS = 0;
    private static final int DATA_SET = 1;
    private static final int LAYER = 2;
    private static final int CURRENT_DEPTH = 3;
    private static final int CURRENT_DIRECTION = 4;
    private static final int DIRECTION_REFERENCE = 5;
    private static final int CURRENT_SPEED = 6;
    private static final int REFERENCE_LAYER_DEPTH = 7;
    private static final int CURRENT_HEADING = 8;
    private static final int HEADING_REFERENCE = 9;
    private static final int SPEED_REFERENCE = 10;

    public CURParser(String nmea) {
        super(nmea, SentenceId.CUR);
    }

    public CURParser(TalkerId talker) {
        super(talker, SentenceId.CUR, 11);
        this.setCharValue(5, 'T');
        this.setCharValue(9, 'T');
        this.setCharValue(10, 'B');
    }

    @Override
    public double getCurrentDirection() {
        return this.getDoubleValue(4);
    }

    @Override
    public String getCurrentDirectionReference() {
        return this.getStringValue(5);
    }

    @Override
    public String getCurrentHeadingReference() {
        return this.getStringValue(9);
    }

    @Override
    public double getCurrentSpeed() {
        return this.getDoubleValue(6);
    }
}

