/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.example;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import net.sf.marineapi.nmea.event.SentenceEvent;
import net.sf.marineapi.nmea.event.SentenceListener;
import net.sf.marineapi.nmea.io.SentenceReader;
import net.sf.marineapi.nmea.sentence.GGASentence;
import net.sf.marineapi.nmea.sentence.SentenceId;

public class FileExample
implements SentenceListener {
    private SentenceReader reader;

    public FileExample(File file) throws IOException {
        FileInputStream stream = new FileInputStream(file);
        this.reader = new SentenceReader(stream);
        this.reader.addSentenceListener((SentenceListener)this, SentenceId.GGA);
        this.reader.start();
    }

    @Override
    public void readingPaused() {
        System.out.println("-- Paused --");
    }

    @Override
    public void readingStarted() {
        System.out.println("-- Started --");
    }

    @Override
    public void readingStopped() {
        System.out.println("-- Stopped --");
    }

    @Override
    public void sentenceRead(SentenceEvent event) {
        GGASentence s = (GGASentence)event.getSentence();
        System.out.println(s.getPosition());
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Example usage:\njava FileExample nmea.log");
            System.exit(1);
        }
        try {
            new FileExample(new File(args[0]));
            System.out.println("Running, press CTRL-C to stop..");
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

