/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.ais.util;

import java.util.BitSet;

public class BitVector {
    private BitSet fBitVector;
    private int fLength;

    public BitVector(int bits) {
        this.fBitVector = new BitSet(bits);
        this.fLength = bits;
    }

    public BitVector(BitSet vector, int bits) {
        this.fBitVector = vector;
        this.fLength = bits;
    }

    public void set(int index) {
        this.fBitVector.set(index);
    }

    public BitVector get(int from, int to) {
        return new BitVector(this.fBitVector.get(++from, ++to), to - from);
    }

    public boolean getBoolean(int index) {
        return this.fBitVector.get(index);
    }

    public int getUInt(int from, int to) {
        int value = 0;
        int i = this.fBitVector.previousSetBit(to);
        while (i > from) {
            value += 1 << to - i;
            i = this.fBitVector.previousSetBit(i - 1);
        }
        return value;
    }

    public int getAs8BitInt(int from, int to) {
        int retval = this.getUInt(from, to);
        if (retval >= 128) {
            retval -= 256;
        }
        return retval;
    }

    public int getAs17BitInt(int from, int to) {
        int retval = this.getUInt(from, to);
        if (retval >= 65536) {
            retval -= 131072;
        }
        return retval;
    }

    public int getAs18BitInt(int from, int to) {
        int retval = this.getUInt(from, to);
        if (retval >= 131072) {
            retval -= 262144;
        }
        return retval;
    }

    public int getAs27BitInt(int from, int to) {
        int retval = this.getUInt(from, to);
        if (retval >= 0x4000000) {
            retval -= 0x8000000;
        }
        return retval;
    }

    public int getAs28BitInt(int from, int to) {
        int retval = this.getUInt(from, to);
        if (retval >= 0x8000000) {
            retval -= 0x10000000;
        }
        return retval;
    }
}

