/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.ais.parser;

import net.sf.marineapi.ais.message.AISPositionReportB;
import net.sf.marineapi.ais.parser.AISMessageParser;
import net.sf.marineapi.ais.util.AISRuleViolation;
import net.sf.marineapi.ais.util.Angle12;
import net.sf.marineapi.ais.util.Angle9;
import net.sf.marineapi.ais.util.Latitude27;
import net.sf.marineapi.ais.util.Longitude28;
import net.sf.marineapi.ais.util.Sixbit;
import net.sf.marineapi.ais.util.SpeedOverGround;
import net.sf.marineapi.ais.util.TimeStamp;

class AISPositionReportBParser
extends AISMessageParser
implements AISPositionReportB {
    protected static final String SEPARATOR = "\n\t";
    private static final int SPEEDOVERGROUND = 0;
    private static final int POSITIONACCURACY = 1;
    private static final int LONGITUDE = 2;
    private static final int LATITUDE = 3;
    private static final int COURSEOVERGROUND = 4;
    private static final int TRUEHEADING = 5;
    private static final int TIMESTAMP = 6;
    private static final int[] FROM = new int[]{46, 56, 57, 85, 112, 124, 133};
    private static final int[] TO = new int[]{56, 57, 85, 112, 124, 133, 139};
    private int fSOG;
    private boolean fPositionAccuracy;
    private int fLongitude;
    private int fLatitude;
    private int fCOG;
    private int fTrueHeading;
    private int fTimeStamp;

    public AISPositionReportBParser(Sixbit content) {
        super(content);
        this.fSOG = content.getInt(FROM[0], TO[0]);
        this.fPositionAccuracy = content.getBoolean(FROM[1]);
        this.fLongitude = content.getAs28BitInt(FROM[2], TO[2]);
        if (!Longitude28.isCorrect(this.fLongitude)) {
            this.addViolation(new AISRuleViolation("LongitudeInDegrees", this.fLongitude, "[-108000000,108000000] + {108600000}"));
        }
        this.fLatitude = content.getAs27BitInt(FROM[3], TO[3]);
        if (!Latitude27.isCorrect(this.fLatitude)) {
            this.addViolation(new AISRuleViolation("LatitudeInDegrees", this.fLatitude, "[-54000000,54000000] + {54600000}"));
        }
        this.fCOG = content.getInt(FROM[4], TO[4]);
        if (!Angle12.isCorrect(this.fCOG)) {
            this.addViolation(new AISRuleViolation("getCourseOverGround", this.fCOG, "[0,3599] + {3600}"));
        }
        this.fTrueHeading = content.getInt(FROM[5], TO[5]);
        if (!Angle9.isCorrect(this.fTrueHeading)) {
            this.addViolation(new AISRuleViolation("getTrueHeading", this.fTrueHeading, "[0,359] + {511}"));
        }
        this.fTimeStamp = content.getInt(FROM[6], TO[6]);
    }

    @Override
    public double getSpeedOverGround() {
        return SpeedOverGround.toKnots(this.fSOG);
    }

    @Override
    public boolean isAccurate() {
        return this.fPositionAccuracy;
    }

    @Override
    public double getLongitudeInDegrees() {
        return Longitude28.toDegrees(this.fLongitude);
    }

    @Override
    public double getLatitudeInDegrees() {
        return Latitude27.toDegrees(this.fLatitude);
    }

    @Override
    public double getCourseOverGround() {
        return Angle12.toDegrees(this.fCOG);
    }

    @Override
    public boolean hasSpeedOverGround() {
        return SpeedOverGround.isAvailable(this.fSOG);
    }

    @Override
    public boolean hasCourseOverGround() {
        return Angle12.isAvailable(this.fCOG);
    }

    @Override
    public boolean hasTrueHeading() {
        return Angle9.isAvailable(this.fTrueHeading);
    }

    @Override
    public boolean hasTimeStamp() {
        return TimeStamp.isAvailable(this.fTimeStamp);
    }

    @Override
    public boolean hasLongitude() {
        return Latitude27.isAvailable(this.fLongitude);
    }

    @Override
    public boolean hasLatitude() {
        return Latitude27.isAvailable(this.fLatitude);
    }

    @Override
    public int getTrueHeading() {
        return this.fTrueHeading;
    }

    @Override
    public int getTimeStamp() {
        return this.fTimeStamp;
    }

    public String toString() {
        String result = "\tSOG:     " + SpeedOverGround.toString(this.fSOG);
        result = result + "\n\tPos acc: " + (this.fPositionAccuracy ? "high" : "low") + " accuracy";
        result = result + "\n\tLon:     " + Longitude28.toString(this.fLongitude);
        result = result + "\n\tLat:     " + Latitude27.toString(this.fLatitude);
        result = result + "\n\tCOG:     " + Angle12.toString(this.fCOG);
        result = result + "\n\tHeading: " + Angle9.getTrueHeadingString(this.fTrueHeading);
        result = result + "\n\tTime:    " + TimeStamp.toString(this.fTimeStamp);
        return result;
    }
}

