/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.ais.parser;

import java.util.ArrayList;
import java.util.List;
import net.sf.marineapi.ais.message.AISMessage;
import net.sf.marineapi.ais.util.Sixbit;
import net.sf.marineapi.ais.util.Violation;
import net.sf.marineapi.nmea.sentence.AISSentence;

public class AISMessageParser
implements AISMessage {
    private static final int MESSAGE_TYPE = 0;
    private static final int REPEAT_INDICATOR = 1;
    private static final int MMSI = 2;
    private static final int[] FROM = new int[]{0, 6, 8};
    private static final int[] TO = new int[]{6, 8, 38};
    private Sixbit decoder;
    private String message = "";
    private int fillBits = 0;
    private int lastFragmentNr = 0;
    private List<Violation> fViolations = new ArrayList<Violation>();

    public AISMessageParser() {
    }

    public AISMessageParser(AISSentence ... sentences) {
        int index = 1;
        for (AISSentence s : sentences) {
            if (s.isFragmented() && s.getFragmentNumber() != index++) {
                throw new IllegalArgumentException("Incorrect order of AIS sentences");
            }
            this.append(s.getPayload(), s.getFragmentNumber(), s.getFillBits());
        }
        this.decoder = new Sixbit(this.message, this.fillBits);
    }

    protected AISMessageParser(Sixbit sb) {
        if (sb.length() <= 0) {
            throw new IllegalArgumentException("Sixbit decoder is empty!");
        }
        this.decoder = sb;
    }

    protected void addViolation(Violation v) {
        this.fViolations.add(v);
    }

    public int getNrOfViolations() {
        return this.fViolations.size();
    }

    public List<Violation> getViolations() {
        return this.fViolations;
    }

    @Override
    public int getMessageType() {
        return this.getSixbit().getInt(FROM[0], TO[0]);
    }

    @Override
    public int getRepeatIndicator() {
        return this.getSixbit().getInt(FROM[1], TO[1]);
    }

    @Override
    public int getMMSI() {
        return this.getSixbit().getInt(FROM[2], TO[2]);
    }

    Sixbit getSixbit() {
        if (this.decoder == null && this.message.isEmpty()) {
            throw new IllegalStateException("Message is empty!");
        }
        return this.decoder == null ? new Sixbit(this.message, this.fillBits) : this.decoder;
    }

    void append(String fragment, int fragmentIndex, int fillBits) {
        if (fragment == null || fragment.isEmpty()) {
            throw new IllegalArgumentException("Message fragment cannot be null or empty");
        }
        if (fragmentIndex < 1 || fragmentIndex != this.lastFragmentNr + 1) {
            throw new IllegalArgumentException("Invalid fragment index or sequence order");
        }
        if (fillBits < 0) {
            throw new IllegalArgumentException("Fill bits cannot be negative");
        }
        this.lastFragmentNr = fragmentIndex;
        this.message = this.message + fragment;
        this.fillBits = fillBits;
    }
}

