/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.ais.parser;

import net.sf.marineapi.ais.message.AISMessage19;
import net.sf.marineapi.ais.parser.AISPositionReportBParser;
import net.sf.marineapi.ais.util.PositioningDevice;
import net.sf.marineapi.ais.util.ShipType;
import net.sf.marineapi.ais.util.Sixbit;

class AISMessage19Parser
extends AISPositionReportBParser
implements AISMessage19 {
    private static final int NAME = 0;
    private static final int TYPEOFSHIPANDCARGO = 1;
    private static final int BOW = 2;
    private static final int STERN = 3;
    private static final int PORT = 4;
    private static final int STARBOARD = 5;
    private static final int TYPEOFEPFD = 6;
    private static final int[] FROM = new int[]{143, 263, 271, 280, 289, 295, 301};
    private static final int[] TO = new int[]{263, 271, 280, 289, 295, 301, 305};
    private String fName;
    private int fShipAndCargoType;
    private int fBow;
    private int fStern;
    private int fPort;
    private int fStarboard;
    private int fTypeOfEPFD;

    public AISMessage19Parser(Sixbit content) {
        super(content);
        if (content.length() != 312) {
            throw new IllegalArgumentException("Wrong message length");
        }
        this.fName = content.getString(FROM[0], TO[0]);
        this.fShipAndCargoType = content.getInt(FROM[1], TO[1]);
        this.fBow = content.getInt(FROM[2], TO[2]);
        this.fStern = content.getInt(FROM[3], TO[3]);
        this.fPort = content.getInt(FROM[4], TO[4]);
        this.fStarboard = content.getInt(FROM[5], TO[5]);
        this.fTypeOfEPFD = content.getInt(FROM[6], TO[6]);
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public int getTypeOfShipAndCargoType() {
        return this.fShipAndCargoType;
    }

    @Override
    public int getBow() {
        return this.fBow;
    }

    @Override
    public int getStern() {
        return this.fStern;
    }

    @Override
    public int getPort() {
        return this.fPort;
    }

    @Override
    public int getStarboard() {
        return this.fStarboard;
    }

    @Override
    public int getTypeOfEPFD() {
        return this.fTypeOfEPFD;
    }

    @Override
    public String toString() {
        String result = super.toString();
        result = result + "\n\tName:    " + this.fName;
        result = result + "\n\tType:    " + ShipType.shipTypeToString(this.fShipAndCargoType);
        String dim = "Bow: " + this.fBow + ", Stern: " + this.fStern + ", Port: " + this.fPort + ", Starboard: " + this.fStarboard + " [m]";
        result = result + "\n\tDim:     " + dim;
        result = result + "\n\tEPFD:    " + PositioningDevice.toString(this.fTypeOfEPFD);
        return result;
    }
}

