/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.ais.event;

import java.util.LinkedList;
import java.util.Queue;
import net.sf.marineapi.ais.message.AISMessage;
import net.sf.marineapi.ais.parser.AISMessageFactory;
import net.sf.marineapi.nmea.event.AbstractSentenceListener;
import net.sf.marineapi.nmea.sentence.AISSentence;
import net.sf.marineapi.util.GenericTypeResolver;

public abstract class AbstractAISMessageListener<T extends AISMessage>
extends AbstractSentenceListener<AISSentence> {
    final Class<?> messageType;
    private final Queue<AISSentence> queue = new LinkedList<AISSentence>();
    private final AISMessageFactory factory = AISMessageFactory.getInstance();

    public AbstractAISMessageListener() {
        this.messageType = GenericTypeResolver.resolve(this.getClass(), AbstractAISMessageListener.class);
    }

    public AbstractAISMessageListener(Class<T> c) {
        this.messageType = c;
    }

    @Override
    public final void sentenceRead(AISSentence sentence) {
        if (sentence.isFirstFragment()) {
            this.queue.clear();
        }
        this.queue.add(sentence);
        if (sentence.isLastFragment()) {
            AISSentence[] sentences = this.queue.toArray(new AISSentence[this.queue.size()]);
            try {
                AISMessage message = this.factory.create(sentences);
                if (this.messageType.isAssignableFrom(message.getClass())) {
                    this.onMessage(message);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public abstract void onMessage(T var1);

    @Override
    public void readingPaused() {
    }

    @Override
    public void readingStarted() {
    }

    @Override
    public void readingStopped() {
    }
}

