/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.task;

import de.riwagis.util.task.BackgroundTaskEventType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackgroundTaskEvent {
    private static final Logger LOG = LoggerFactory.getLogger(BackgroundTaskEvent.class);
    private final String message;
    private final Throwable exception;
    private final BackgroundTaskEventType bgTaskType;

    public BackgroundTaskEvent(BackgroundTaskEventType _bgTaskType, String _message) {
        this(_bgTaskType, _message, null);
    }

    public BackgroundTaskEvent(BackgroundTaskEventType _bgTaskType, String _message, Throwable _exception) {
        this.bgTaskType = _bgTaskType;
        this.message = _message;
        this.exception = _exception;
        if (LOG.isTraceEnabled()) {
            LOG.trace(String.format("current Task: %s", this), _exception);
        }
    }

    public BackgroundTaskEventType getBgTaskType() {
        return this.bgTaskType;
    }

    public Throwable getException() {
        return this.exception;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return String.format("BackgroundTaskEvent '%s': %s (Exception: %s)", new Object[]{this.bgTaskType, this.message, this.exception == null ? "---" : this.exception.getMessage()});
    }
}

