/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.system;

import de.riwagis.util.file.FileSupport;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.LogOutputStream;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.io.output.TeeOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeExec {
    private static final Logger LOG = LoggerFactory.getLogger(RuntimeExec.class);

    public static int runCommandLine(String commandlineText, File workDir, File logFile, final Logger logger) throws IOException {
        LinkedHashSet<OutputStream> outStreams = new LinkedHashSet<OutputStream>();
        if (logger != null) {
            outStreams.add((OutputStream)new LogOutputStream(){

                protected void processLine(String line, int level) {
                    logger.debug(line);
                }
            });
        }
        if (logFile != null) {
            FileSupport.mkParentDirs((File)logFile);
            outStreams.add(new BufferedOutputStream(new FileOutputStream(logFile, true)));
        }
        try (OutputStream stdOutOS = RuntimeExec.buildMultiOutputStream(outStreams);){
            int exitValue;
            ByteArrayOutputStream s = new ByteArrayOutputStream();
            try (TeeOutputStream stdErrOS = new TeeOutputStream(stdOutOS, (OutputStream)s);){
                DefaultExecutor exec = new DefaultExecutor();
                exec.setWorkingDirectory(workDir == null ? new File(".") : workDir);
                CommandLine commandline = CommandLine.parse((String)commandlineText);
                exec.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler(stdOutOS, (OutputStream)stdErrOS));
                LOG.info(String.format("Starting '%s' in workDir '%s'", commandline, workDir));
                exitValue = exec.execute(commandline);
            }
            String stdErrText = s.toString("ISO8859-15");
            if (stdErrText.length() > 0) {
                throw new IOException(String.format("Fehler bei der Ausf\u00fchrung von '%s':%nMeldung: '%s'", commandlineText, stdErrText));
            }
            if (exitValue != 0) {
                throw new IOException(String.format("Fehler bei der Ausf\u00fchrung von '%s': %d", commandlineText, exitValue));
            }
            int n = exitValue;
            return n;
        }
    }

    public static OutputStream buildMultiOutputStream(Collection<OutputStream> outStreams) {
        ArrayList<OutputStream> finalStreams = new ArrayList<OutputStream>(outStreams);
        if (finalStreams.isEmpty()) {
            finalStreams.add((OutputStream)new NullOutputStream());
        }
        OutputStream os = null;
        for (OutputStream currOutputStream : outStreams) {
            if (currOutputStream == null) continue;
            os = os == null ? currOutputStream : new TeeOutputStream(os, currOutputStream);
        }
        return os;
    }

    private RuntimeExec() {
    }
}

