/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.network;

import de.riwagis.util.exception.SystemException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.Enumeration;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetworkSupport {
    private static final Logger LOG = LoggerFactory.getLogger(NetworkSupport.class);
    private static final byte[] defaultMac = new byte[]{2, 44, -22, 3, 23, -23};
    public static final int MAX_RELEVANT_BITS = 32;
    public static final int IP_OCTET_COUNT = 4;

    private NetworkSupport() {
    }

    public static final String generatePassword(int length) {
        char[] validChars = "abcdefghijkmnopqrstuvwxyzABCDEFGHIJKLMNPQRTUVWXYZ23456789".toCharArray();
        StringBuilder sbPwd = new StringBuilder();
        for (int i = 1; i < length + 1; ++i) {
            int intIndex = (int)Math.round(Math.random() * ((double)validChars.length * 101.0)) % validChars.length;
            sbPwd.append(validChars[intIndex]);
        }
        return sbPwd.toString();
    }

    public static final String getIPAdress() throws SystemException {
        try {
            InetAddress localaddr = InetAddress.getLocalHost();
            return localaddr.getHostAddress();
        }
        catch (Exception e) {
            throw new SystemException(NetworkSupport.class, (Throwable)e);
        }
    }

    public static final byte[] getMACAdress() throws SystemException {
        try {
            if (System.getProperty("os.name").equalsIgnoreCase("linux")) {
                return defaultMac;
            }
            String[] arrJava = System.getProperty("java.version").split("\\.");
            float fltJava = Float.parseFloat(arrJava[0] + "." + arrJava[1]);
            if (fltJava < 1.6f) {
                return defaultMac;
            }
            NetworkInterface ni = NetworkInterface.getByInetAddress(InetAddress.getLocalHost());
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            Object obj = ni.getClass().getMethod("getHardwareAddress", new Class[0]).invoke((Object)ni, new Object[0]);
            if (obj == null) {
                return defaultMac;
            }
            byte[] arrMacAdr = (byte[])obj;
            return arrMacAdr;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException | SocketException | UnknownHostException e) {
            throw new SystemException(NetworkSupport.class, (Throwable)e);
        }
    }

    public static final String getMACAdressStr() throws SystemException {
        try {
            StringBuilder sbMacAdr = new StringBuilder();
            byte[] arrMacAdr = NetworkSupport.getMACAdress();
            for (int i = 0; i < arrMacAdr.length; ++i) {
                if (sbMacAdr.length() > 0) {
                    sbMacAdr.append('.');
                }
                sbMacAdr.append("" + arrMacAdr[i]);
            }
            return sbMacAdr.toString();
        }
        catch (Exception e) {
            throw new SystemException(NetworkSupport.class, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean isPortAvailable(int port) {
        ServerSocket srv = null;
        try {
            srv = new ServerSocket(port);
            srv.close();
            srv = null;
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                srv.close();
            }
            catch (Exception exception) {}
        }
    }

    public static final boolean validateIPv4(String strIP2Validate, String strIP4Validate) {
        if (StringUtils.isNotBlank((CharSequence)strIP2Validate) && StringUtils.isNotBlank((CharSequence)strIP4Validate)) {
            long intIP2Validate;
            try {
                intIP2Validate = NetworkSupport.getInt4IPv4(strIP2Validate.trim());
            }
            catch (ParseException pe) {
                LOG.debug("Illegal IP encountered: " + strIP2Validate, (Throwable)pe);
                return false;
            }
            String[] arrIPs4Validate = strIP4Validate.trim().split(";");
            for (int i = 0; i < arrIPs4Validate.length; ++i) {
                String[] arrIPRegion = arrIPs4Validate[i].trim().split("\\/");
                if (arrIPRegion.length == 2) {
                    int relevantBits = NumberUtils.toInt((String)arrIPRegion[1], (int)-1);
                    if (relevantBits >= 0 && relevantBits <= 32) {
                        long intRegion = (long)Math.pow(2.0, 32 - relevantBits);
                        try {
                            long intIP4ValidateMin = NetworkSupport.getInt4IPv4(arrIPRegion[0], relevantBits);
                            long intIP4ValidateMax = intIP4ValidateMin + intRegion - 1L;
                            if (intIP2Validate >= intIP4ValidateMin && intIP2Validate <= intIP4ValidateMax) {
                                return true;
                            }
                        }
                        catch (ParseException pe) {
                            LOG.debug("Illegal IP encountered: " + arrIPs4Validate[i], (Throwable)pe);
                        }
                        continue;
                    }
                    LOG.debug("Illegal relevant bits: " + arrIPRegion[1]);
                    continue;
                }
                if (arrIPRegion.length == 1) {
                    try {
                        long intIP4Validate = NetworkSupport.getInt4IPv4(arrIPs4Validate[i]);
                        if (intIP2Validate == intIP4Validate) {
                            return true;
                        }
                    }
                    catch (ParseException pe) {
                        LOG.debug("Illegal IP encountered: " + arrIPs4Validate[i], (Throwable)pe);
                    }
                    if (!StringUtils.isNotBlank((CharSequence)arrIPRegion[0]) || !StringUtils.startsWith((CharSequence)strIP2Validate, (CharSequence)arrIPRegion[0])) continue;
                    return true;
                }
                LOG.debug("Given IP4validate not valid");
            }
        }
        return false;
    }

    public static final long getInt4IPv4(String strIP) throws ParseException {
        return NetworkSupport.getInt4IPv4(strIP, 32);
    }

    public static final long getInt4IPv4(String strIP, int relevantBits) throws ParseException {
        try {
            String[] arrIP = strIP.split("\\.");
            if (arrIP.length != 4) {
                throw new ParseException("Given IP not valid", 0);
            }
            long value = 0L;
            for (String currOctet : arrIP) {
                int intIPPart = Integer.parseInt(currOctet);
                if (intIPPart < 0 || intIPPart > 255) {
                    throw new ParseException(String.format("Given IP '%s' not valid", strIP), 0);
                }
                value = (value << 8) + (long)intIPPart;
            }
            return value &= 0xFFFFFFFFL >> relevantBits ^ 0xFFFFFFFFL;
        }
        catch (NumberFormatException nfex) {
            throw new ParseException(String.format("Given IP '%s' is not valid: %s", strIP, nfex.getMessage()), 0);
        }
    }
}

