/*
 * Decompiled with CFR 0.152.
 */
package de.riwagis.util.mail;

import java.util.Objects;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailException;

public class SMTPConfig {
    @NonNull
    private final String smtpHost;
    private final int smtpPort;
    private final String smtpLogin;
    private final String smtpPassword;
    private final String addressFrom;
    private final String replyToAdress;
    private final boolean useReplyToAdress;

    public static SMTPConfigBuilder builder(String smtpHost) {
        return new SMTPConfigBuilder().smtpHost(smtpHost);
    }

    public SMTPConfig(String smtpHost, int smtpPort, String smtpLogin, String smtpPassword, String addressFrom, String replyTo, boolean useReplyToAdress) {
        this.smtpHost = Objects.requireNonNull(StringUtils.trimToNull((String)smtpHost));
        this.smtpPort = Objects.requireNonNullElse(smtpPort, 25);
        this.smtpLogin = smtpLogin;
        this.smtpPassword = smtpPassword;
        this.addressFrom = addressFrom;
        this.replyToAdress = replyTo;
        this.useReplyToAdress = useReplyToAdress;
    }

    public SMTPConfig(String smtpHost, int smtpPort, String smtpLogin, String smtpPassword, String addressFrom, String replyTo) {
        this(smtpHost, smtpPort, smtpLogin, smtpPassword, addressFrom, replyTo, false);
    }

    public SMTPConfig(String smtpHost, int smtpPort, String smtpLogin, String smtpPassword, String addressFrom) {
        this(smtpHost, smtpPort, smtpLogin, smtpPassword, addressFrom, null);
    }

    public SMTPConfig(String smtpHost, String strFrom, String replyTo) {
        this(smtpHost, 25, null, null, strFrom, replyTo);
    }

    public SMTPConfig(String smtpHost, String strFrom) {
        this(smtpHost, strFrom, null);
    }

    public final void fillMail(Email mail) throws EmailException {
        mail.setHostName(this.getSmtpHost());
        mail.setSmtpPort(this.getSmtpPort());
        if (StringUtils.isNotBlank((CharSequence)this.getSmtpLogin()) && this.getSmtpPassword() != null) {
            mail.setAuthentication(this.getSmtpLogin(), this.getSmtpPassword());
        }
        mail.setFrom(this.getAddressFrom());
        if (StringUtils.isNotEmpty((CharSequence)this.getReplyToAdress()) && this.isUseReplyToAdress()) {
            mail.addReplyTo(this.getReplyToAdress());
        }
    }

    public String toString() {
        return "SMTPConfig(smtpHost=" + this.getSmtpHost() + ", smtpPort=" + this.getSmtpPort() + ", smtpLogin=" + this.getSmtpLogin() + ", smtpPassword=" + this.getSmtpPassword() + ", addressFrom=" + this.getAddressFrom() + ", replyToAdress=" + this.getReplyToAdress() + ", useReplyToAdress=" + this.isUseReplyToAdress() + ")";
    }

    @NonNull
    public String getSmtpHost() {
        return this.smtpHost;
    }

    public int getSmtpPort() {
        return this.smtpPort;
    }

    public String getSmtpLogin() {
        return this.smtpLogin;
    }

    public String getSmtpPassword() {
        return this.smtpPassword;
    }

    public String getAddressFrom() {
        return this.addressFrom;
    }

    public String getReplyToAdress() {
        return this.replyToAdress;
    }

    public boolean isUseReplyToAdress() {
        return this.useReplyToAdress;
    }

    public static class SMTPConfigBuilder {
        private String smtpHost;
        private int smtpPort;
        private String smtpLogin;
        private String smtpPassword;
        private String addressFrom;
        private String replyToAdress;
        private boolean useReplyToAdress;

        SMTPConfigBuilder() {
        }

        public SMTPConfigBuilder smtpHost(@NonNull String smtpHost) {
            if (smtpHost == null) {
                throw new NullPointerException("smtpHost is marked non-null but is null");
            }
            this.smtpHost = smtpHost;
            return this;
        }

        public SMTPConfigBuilder smtpPort(int smtpPort) {
            this.smtpPort = smtpPort;
            return this;
        }

        public SMTPConfigBuilder smtpLogin(String smtpLogin) {
            this.smtpLogin = smtpLogin;
            return this;
        }

        public SMTPConfigBuilder smtpPassword(String smtpPassword) {
            this.smtpPassword = smtpPassword;
            return this;
        }

        public SMTPConfigBuilder addressFrom(String addressFrom) {
            this.addressFrom = addressFrom;
            return this;
        }

        public SMTPConfigBuilder replyToAdress(String replyToAdress) {
            this.replyToAdress = replyToAdress;
            return this;
        }

        public SMTPConfigBuilder useReplyToAdress(boolean useReplyToAdress) {
            this.useReplyToAdress = useReplyToAdress;
            return this;
        }

        public SMTPConfig build() {
            return new SMTPConfig(this.smtpHost, this.smtpPort, this.smtpLogin, this.smtpPassword, this.addressFrom, this.replyToAdress, this.useReplyToAdress);
        }

        public String toString() {
            return "SMTPConfig.SMTPConfigBuilder(smtpHost=" + this.smtpHost + ", smtpPort=" + this.smtpPort + ", smtpLogin=" + this.smtpLogin + ", smtpPassword=" + this.smtpPassword + ", addressFrom=" + this.addressFrom + ", replyToAdress=" + this.replyToAdress + ", useReplyToAdress=" + this.useReplyToAdress + ")";
        }
    }
}

